/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.filter;

import io.confluent.connect.hdfs.HdfsSinkConnectorConstants;
import io.confluent.connect.hdfs.filter.CommittedFileFilter;
import java.util.regex.Matcher;
import org.apache.hadoop.fs.Path;

public class TopicCommittedFileFilter
extends CommittedFileFilter {
    private String topic;

    public TopicCommittedFileFilter(String topic) {
        this.topic = topic;
    }

    @Override
    public boolean accept(Path path) {
        if (!super.accept(path)) {
            return false;
        }
        String filename = path.getName();
        Matcher m = HdfsSinkConnectorConstants.COMMITTED_FILENAME_PATTERN.matcher(filename);
        if (!m.matches()) {
            throw new AssertionError((Object)"match expected because of CommittedFileFilter");
        }
        String topic = m.group(1);
        return topic.equals(this.topic);
    }
}

