/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.filter;

import io.confluent.connect.hdfs.HdfsSinkConnectorConstants;
import io.confluent.connect.hdfs.filter.CommittedFileFilter;
import java.util.regex.Matcher;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.common.TopicPartition;

public class TopicPartitionCommittedFileFilter
extends CommittedFileFilter {
    private TopicPartition tp;

    public TopicPartitionCommittedFileFilter(TopicPartition tp) {
        this.tp = tp;
    }

    @Override
    public boolean accept(Path path) {
        if (!super.accept(path)) {
            return false;
        }
        String filename = path.getName();
        Matcher m = HdfsSinkConnectorConstants.COMMITTED_FILENAME_PATTERN.matcher(filename);
        if (!m.matches()) {
            throw new AssertionError((Object)"match expected because of CommittedFileFilter");
        }
        String topic = m.group(1);
        int partition = Integer.parseInt(m.group(2));
        return topic.equals(this.tp.topic()) && partition == this.tp.partition();
    }
}

