/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.json;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.json.JsonFileReader;
import io.confluent.connect.hdfs.json.JsonRecordWriterProvider;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.storage.format.Format;
import io.confluent.connect.storage.format.RecordWriterProvider;
import io.confluent.connect.storage.format.SchemaFileReader;
import io.confluent.connect.storage.hive.HiveFactory;
import java.util.HashMap;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.connect.json.JsonConverter;

public class JsonFormat
implements Format<HdfsSinkConnectorConfig, Path> {
    private final HdfsStorage storage;
    private final JsonConverter converter;

    public JsonFormat(HdfsStorage storage) {
        this.storage = storage;
        this.converter = new JsonConverter();
        HashMap<String, String> converterConfig = new HashMap<String, String>();
        converterConfig.put("schemas.enable", "false");
        converterConfig.put("schemas.cache.size", String.valueOf(storage.conf().get("schemas.cache.config")));
        this.converter.configure(converterConfig, false);
    }

    public RecordWriterProvider<HdfsSinkConnectorConfig> getRecordWriterProvider() {
        return new JsonRecordWriterProvider(this.storage, this.converter);
    }

    public SchemaFileReader<HdfsSinkConnectorConfig, Path> getSchemaFileReader() {
        return new JsonFileReader();
    }

    public HiveFactory getHiveFactory() {
        throw new UnsupportedOperationException("Hive integration is not currently supported with JSON format");
    }
}

