/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRecordWriterProvider
implements RecordWriterProvider<HdfsSinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(JsonRecordWriterProvider.class);
    private static final String EXTENSION = ".json";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final byte[] LINE_SEPARATOR_BYTES = LINE_SEPARATOR.getBytes(StandardCharsets.UTF_8);
    private final HdfsStorage storage;
    private final ObjectMapper mapper;
    private final JsonConverter converter;

    JsonRecordWriterProvider(HdfsStorage storage, JsonConverter converter) {
        this.storage = storage;
        this.mapper = new ObjectMapper();
        this.converter = converter;
    }

    public String getExtension() {
        return EXTENSION;
    }

    public RecordWriter getRecordWriter(HdfsSinkConnectorConfig conf, final String filename) {
        try {
            return new RecordWriter(){
                final OutputStream out;
                final JsonGenerator writer;
                {
                    this.out = JsonRecordWriterProvider.this.storage.create(filename, true);
                    this.writer = JsonRecordWriterProvider.this.mapper.getFactory().createGenerator(this.out).setRootValueSeparator(null);
                }

                public void write(SinkRecord record) {
                    log.trace("Sink record: {}", (Object)record.toString());
                    try {
                        Object value = record.value();
                        if (value instanceof Struct) {
                            byte[] rawJson = JsonRecordWriterProvider.this.converter.fromConnectData(record.topic(), record.valueSchema(), value);
                            this.out.write(rawJson);
                            this.out.write(LINE_SEPARATOR_BYTES);
                        } else {
                            this.writer.writeObject(value);
                            this.writer.writeRaw(LINE_SEPARATOR);
                        }
                    }
                    catch (IOException e) {
                        throw new ConnectException((Throwable)e);
                    }
                }

                public void commit() {
                }

                public void close() {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {
                        throw new ConnectException((Throwable)e);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }
}

