/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.orc;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.storage.format.SchemaFileReader;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileReader
implements SchemaFileReader<HdfsSinkConnectorConfig, Path> {
    private static final Logger log = LoggerFactory.getLogger(OrcFileReader.class);

    public Schema getSchema(HdfsSinkConnectorConfig conf, Path path) {
        try {
            log.debug("Opening ORC record reader for: {}", (Object)path);
            OrcFile.ReaderOptions readerOptions = new OrcFile.ReaderOptions(conf.getHadoopConfiguration());
            Reader reader = OrcFile.createReader((Path)path, (OrcFile.ReaderOptions)readerOptions);
            if (reader.getObjectInspector().getCategory() == ObjectInspector.Category.STRUCT) {
                SchemaBuilder schemaBuilder = SchemaBuilder.struct().name("record").version(Integer.valueOf(1));
                StructObjectInspector objectInspector = (StructObjectInspector)reader.getObjectInspector();
                for (StructField schema : objectInspector.getAllStructFieldRefs()) {
                    Schema.Type schemaType;
                    ObjectInspector fieldObjectInspector = schema.getFieldObjectInspector();
                    String typeName = fieldObjectInspector.getTypeName();
                    switch (fieldObjectInspector.getCategory()) {
                        case PRIMITIVE: {
                            PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName((String)typeName);
                            if (Date.class.isAssignableFrom(typeEntry.primitiveJavaClass)) {
                                schemaType = org.apache.kafka.connect.data.Date.SCHEMA.type();
                                break;
                            }
                            if (Timestamp.class.isAssignableFrom(typeEntry.primitiveJavaClass)) {
                                schemaType = org.apache.kafka.connect.data.Timestamp.SCHEMA.type();
                                break;
                            }
                            schemaType = ConnectSchema.schemaType((Class)typeEntry.primitiveJavaClass);
                            break;
                        }
                        case LIST: {
                            schemaType = Schema.Type.ARRAY;
                            break;
                        }
                        case MAP: {
                            schemaType = Schema.Type.MAP;
                            break;
                        }
                        default: {
                            throw new DataException("Unknown type " + fieldObjectInspector.getCategory().name());
                        }
                    }
                    schemaBuilder.field(schema.getFieldName(), SchemaBuilder.type((Schema.Type)schemaType).build());
                }
                return schemaBuilder.build();
            }
            throw new ConnectException("Top level type must be of type STRUCT, but was " + reader.getObjectInspector().getCategory().name());
        }
        catch (IOException e) {
            throw new ConnectException("Failed to get schema for file " + path, (Throwable)e);
        }
    }

    public boolean hasNext() {
        throw new UnsupportedOperationException();
    }

    public Object next() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Iterator<Object> iterator() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

