/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.orc;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.storage.errors.HiveMetaStoreException;
import io.confluent.connect.storage.hive.HiveMetaStore;
import io.confluent.connect.storage.hive.HiveSchemaConverter;
import io.confluent.connect.storage.hive.HiveUtil;
import io.confluent.connect.storage.partitioner.Partitioner;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Schema;

public class OrcHiveUtil
extends HiveUtil {
    private final HdfsSinkConnectorConfig config;

    public OrcHiveUtil(HdfsSinkConnectorConfig config, HiveMetaStore hiveMetaStore) {
        super((AbstractConfig)config, hiveMetaStore);
        this.config = config;
    }

    public void alterSchema(String database, String tableName, Schema schema) {
        Table table = this.hiveMetaStore.getTable(database, tableName);
        List columns = HiveSchemaConverter.convertSchema((Schema)schema);
        table.setFields(columns);
        this.hiveMetaStore.alterTable(table);
    }

    public void createTable(String database, String tableName, Schema schema, Partitioner<FieldSchema> partitioner, String topic) throws HiveMetaStoreException {
        Table table = this.constructOrcTable(database, tableName, schema, partitioner, topic);
        this.hiveMetaStore.createTable(table);
    }

    private Table constructOrcTable(String database, String tableName, Schema schema, Partitioner<FieldSchema> partitioner, String topic) throws HiveMetaStoreException {
        Table table = this.newTable(database, tableName);
        table.setTableType(TableType.EXTERNAL_TABLE);
        table.getParameters().put("EXTERNAL", "TRUE");
        String tablePath = this.hiveDirectoryName(this.url, this.config.getTopicsDirFromTopic(topic), topic);
        table.setDataLocation(new Path(tablePath));
        table.setSerializationLib(this.getHiveOrcSerde());
        try {
            table.setInputFormatClass(this.getHiveOrcInputFormat());
            table.setOutputFormatClass(this.getHiveOrcOutputFormat());
        }
        catch (HiveException e) {
            throw new HiveMetaStoreException("Cannot find input/output format:", (Throwable)e);
        }
        List columns = HiveSchemaConverter.convertSchema((Schema)schema);
        table.setFields(columns);
        table.setPartCols(partitioner.partitionFields());
        return table;
    }

    private String getHiveOrcInputFormat() {
        return OrcInputFormat.class.getName();
    }

    private String getHiveOrcOutputFormat() {
        return OrcOutputFormat.class.getName();
    }

    private String getHiveOrcSerde() {
        return OrcSerde.class.getName();
    }
}

