/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.orc;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.orc.OrcUtil;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import io.confluent.connect.storage.hive.HiveSchemaConverter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.orc.OrcFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcRecordWriterProvider
implements RecordWriterProvider<HdfsSinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(OrcRecordWriterProvider.class);
    private static final String EXTENSION = ".orc";

    public String getExtension() {
        return EXTENSION;
    }

    public RecordWriter getRecordWriter(final HdfsSinkConnectorConfig conf, final String filename) {
        final Path path = new Path(filename);
        return new RecordWriter(){
            Writer writer;
            TypeInfo typeInfo;
            Schema schema;

            public void write(SinkRecord record) {
                try {
                    if (this.schema == null) {
                        this.schema = record.valueSchema();
                        if (this.schema.type() == Schema.Type.STRUCT) {
                            OrcFile.WriterCallback writerCallback = new OrcFile.WriterCallback(){

                                public void preStripeWrite(OrcFile.WriterContext writerContext) {
                                }

                                public void preFooterWrite(OrcFile.WriterContext writerContext) {
                                }
                            };
                            this.typeInfo = HiveSchemaConverter.convert((Schema)this.schema);
                            ObjectInspector objectInspector = OrcStruct.createObjectInspector((TypeInfo)this.typeInfo);
                            log.info("Opening ORC record writer for: {}", (Object)filename);
                            this.writer = OrcFile.createWriter((Path)path, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf.getHadoopConfiguration()).inspector(objectInspector).callback(writerCallback));
                        }
                    }
                    if (this.schema.type() != Schema.Type.STRUCT) {
                        throw new ConnectException("Top level type must be STRUCT but was " + this.schema.type().getName());
                    }
                    log.trace("Writing record from topic {} partition {} offset {}", new Object[]{record.topic(), record.kafkaPartition(), record.kafkaOffset()});
                    Struct struct = (Struct)record.value();
                    OrcStruct row = OrcUtil.createOrcStruct(this.typeInfo, OrcUtil.convertStruct(struct));
                    this.writer.addRow((Object)row);
                }
                catch (IOException e) {
                    throw new ConnectException("Failed to write record: ", (Throwable)e);
                }
            }

            public void close() {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException e) {
                    throw new ConnectException("Failed to close ORC writer:", (Throwable)e);
                }
            }

            public void commit() {
            }
        };
    }
}

