/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.orc;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.ArrayPrimitiveWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public final class OrcUtil {
    private static Map<Schema.Type, BiFunction<Struct, Field, Object>> CONVERSION_MAP = new HashMap<Schema.Type, BiFunction<Struct, Field, Object>>();

    public static OrcStruct createOrcStruct(TypeInfo typeInfo, Object ... objs) {
        SettableStructObjectInspector oi = (SettableStructObjectInspector)OrcStruct.createObjectInspector((TypeInfo)typeInfo);
        List fields = oi.getAllStructFieldRefs();
        OrcStruct result = (OrcStruct)oi.create();
        result.setNumFields(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            oi.setStructFieldData((Object)result, (StructField)fields.get(i), objs[i]);
        }
        return result;
    }

    public static Object[] convertStruct(Struct struct) {
        LinkedList<Object> data = new LinkedList<Object>();
        for (Field field : struct.schema().fields()) {
            if (struct.get(field) == null) {
                data.add(null);
                continue;
            }
            Schema.Type schemaType = field.schema().type();
            data.add(CONVERSION_MAP.get(schemaType).apply(struct, field));
        }
        return data.toArray();
    }

    private static Object convertStruct(Struct struct, Field field) {
        return OrcUtil.convertStruct(struct.getStruct(field.name()));
    }

    private static Object convertArray(Struct struct, Field field) {
        return new ArrayPrimitiveWritable((Object)struct.getArray(field.name()).toArray());
    }

    private static Object convertBoolean(Struct struct, Field field) {
        return new BooleanWritable(struct.getBoolean(field.name()).booleanValue());
    }

    private static Object convertBytes(Struct struct, Field field) {
        return new BytesWritable(struct.getBytes(field.name()));
    }

    private static Object convertFloat32(Struct struct, Field field) {
        return new FloatWritable(struct.getFloat32(field.name()).floatValue());
    }

    private static Object convertFloat64(Struct struct, Field field) {
        return new DoubleWritable(struct.getFloat64(field.name()).doubleValue());
    }

    private static Object convertInt8(Struct struct, Field field) {
        return new ByteWritable(struct.getInt8(field.name()).byteValue());
    }

    private static Object convertInt16(Struct struct, Field field) {
        return new ShortWritable(struct.getInt16(field.name()).shortValue());
    }

    private static Object convertInt32(Struct struct, Field field) {
        if ("org.apache.kafka.connect.data.Date".equals(field.schema().name())) {
            java.util.Date date = (java.util.Date)struct.get(field);
            return new DateWritable(new Date(date.getTime()));
        }
        if ("org.apache.kafka.connect.data.Time".equals(field.schema().name())) {
            java.util.Date date = (java.util.Date)struct.get(field);
            return new TimestampWritable(new Timestamp(date.getTime()));
        }
        return new IntWritable(struct.getInt32(field.name()).intValue());
    }

    private static Object convertInt64(Struct struct, Field field) {
        if ("org.apache.kafka.connect.data.Timestamp".equals(field.schema().name())) {
            java.util.Date date = (java.util.Date)struct.get(field);
            return new TimestampWritable(new Timestamp(date.getTime()));
        }
        return new LongWritable(struct.getInt64(field.name()).longValue());
    }

    private static Object convertMap(Struct struct, Field field) {
        MapWritable mapWritable = new MapWritable();
        struct.getMap(field.name()).forEach((key, value) -> mapWritable.put((Writable)new ObjectWritable(key), (Writable)new ObjectWritable(value)));
        return mapWritable;
    }

    private static Object convertString(Struct struct, Field field) {
        return new Text(struct.getString(field.name()));
    }

    static {
        CONVERSION_MAP.put(Schema.Type.ARRAY, OrcUtil::convertArray);
        CONVERSION_MAP.put(Schema.Type.BOOLEAN, OrcUtil::convertBoolean);
        CONVERSION_MAP.put(Schema.Type.BYTES, OrcUtil::convertBytes);
        CONVERSION_MAP.put(Schema.Type.FLOAT32, OrcUtil::convertFloat32);
        CONVERSION_MAP.put(Schema.Type.FLOAT64, OrcUtil::convertFloat64);
        CONVERSION_MAP.put(Schema.Type.INT8, OrcUtil::convertInt8);
        CONVERSION_MAP.put(Schema.Type.INT16, OrcUtil::convertInt16);
        CONVERSION_MAP.put(Schema.Type.INT32, OrcUtil::convertInt32);
        CONVERSION_MAP.put(Schema.Type.INT64, OrcUtil::convertInt64);
        CONVERSION_MAP.put(Schema.Type.MAP, OrcUtil::convertMap);
        CONVERSION_MAP.put(Schema.Type.STRING, OrcUtil::convertString);
        CONVERSION_MAP.put(Schema.Type.STRUCT, OrcUtil::convertStruct);
    }
}

