/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.parquet;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.storage.format.SchemaFileReader;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;

public class ParquetFileReader
implements SchemaFileReader<HdfsSinkConnectorConfig, Path> {
    private AvroData avroData;

    public ParquetFileReader(AvroData avroData) {
        this.avroData = avroData;
    }

    public Schema getSchema(HdfsSinkConnectorConfig conf, Path path) {
        AvroReadSupport readSupport = new AvroReadSupport();
        ParquetReader.Builder builder = ParquetReader.builder((ReadSupport)readSupport, (Path)path);
        try {
            GenericRecord record;
            ParquetReader parquetReader = builder.withConf(conf.getHadoopConfiguration()).build();
            Schema schema = null;
            while ((record = (GenericRecord)parquetReader.read()) != null) {
                schema = this.avroData.toConnectSchema(record.getSchema());
            }
            parquetReader.close();
            return schema;
        }
        catch (IOException e) {
            throw new DataException((Throwable)e);
        }
    }

    public boolean hasNext() {
        throw new UnsupportedOperationException();
    }

    public Object next() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Iterator<Object> iterator() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

