/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.parquet;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.parquet.ParquetFileReader;
import io.confluent.connect.hdfs.parquet.ParquetHiveFactory;
import io.confluent.connect.hdfs.parquet.ParquetRecordWriterProvider;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.storage.format.Format;
import io.confluent.connect.storage.format.RecordWriterProvider;
import io.confluent.connect.storage.format.SchemaFileReader;
import io.confluent.connect.storage.hive.HiveFactory;
import org.apache.hadoop.fs.Path;

public class ParquetFormat
implements Format<HdfsSinkConnectorConfig, Path> {
    private final AvroData avroData;

    public ParquetFormat(HdfsStorage storage) {
        this.avroData = new AvroData(storage.conf().avroDataConfig());
    }

    public RecordWriterProvider<HdfsSinkConnectorConfig> getRecordWriterProvider() {
        return new ParquetRecordWriterProvider(this.avroData);
    }

    public SchemaFileReader<HdfsSinkConnectorConfig, Path> getSchemaFileReader() {
        return new ParquetFileReader(this.avroData);
    }

    public HiveFactory getHiveFactory() {
        return new ParquetHiveFactory();
    }
}

