/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.parquet;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.hive.HiveMetaStore;
import io.confluent.connect.hdfs.hive.HiveUtil;
import io.confluent.connect.hdfs.partitioner.Partitioner;
import io.confluent.connect.storage.errors.HiveMetaStoreException;
import io.confluent.connect.storage.hive.HiveSchemaConverter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kafka.connect.data.Schema;

public class ParquetHiveUtil
extends HiveUtil {
    private final HdfsSinkConnectorConfig config;

    public ParquetHiveUtil(HdfsSinkConnectorConfig conf, HiveMetaStore hiveMetaStore) {
        super(conf, hiveMetaStore);
        this.config = conf;
    }

    @Override
    public void createTable(String database, String tableName, Schema schema, Partitioner partitioner, String topic) throws HiveMetaStoreException {
        Table table = this.constructParquetTable(database, tableName, schema, partitioner, topic);
        this.hiveMetaStore.createTable(table);
    }

    public void alterSchema(String database, String tableName, Schema schema) {
        Table table = this.hiveMetaStore.getTable(database, tableName);
        List columns = HiveSchemaConverter.convertSchema((Schema)schema);
        this.removeFieldPartitionColumn(columns, table.getPartitionKeys());
        table.setFields(columns);
        this.hiveMetaStore.alterTable(table);
    }

    private Table constructParquetTable(String database, String tableName, Schema schema, Partitioner partitioner, String topic) throws HiveMetaStoreException {
        Table table = this.newTable(database, tableName);
        table.setTableType(TableType.EXTERNAL_TABLE);
        table.getParameters().put("EXTERNAL", "TRUE");
        String tablePath = this.hiveDirectoryName(this.url, this.config.getTopicsDirFromTopic(topic), topic);
        table.setDataLocation(new Path(tablePath));
        table.setSerializationLib(this.getHiveParquetSerde());
        try {
            table.setInputFormatClass(this.getHiveParquetInputFormat());
            table.setOutputFormatClass(this.getHiveParquetOutputFormat());
        }
        catch (HiveException e) {
            throw new HiveMetaStoreException("Cannot find input/output format:", (Throwable)e);
        }
        List columns = HiveSchemaConverter.convertSchema((Schema)schema);
        this.removeFieldPartitionColumn(columns, partitioner.partitionFields());
        table.setFields(columns);
        table.setPartCols(partitioner.partitionFields());
        return table;
    }

    private String getHiveParquetInputFormat() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat";
        String oldClass = "parquet.hive.DeprecatedParquetInputFormat";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    private String getHiveParquetOutputFormat() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat";
        String oldClass = "parquet.hive.DeprecatedParquetOutputFormat";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    private String getHiveParquetSerde() {
        String newClass = "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe";
        String oldClass = "parquet.hive.serde.ParquetHiveSerDe";
        try {
            Class.forName(newClass);
            return newClass;
        }
        catch (ClassNotFoundException ex) {
            return oldClass;
        }
    }

    private void removeFieldPartitionColumn(List<FieldSchema> columns, List<FieldSchema> partitionFields) {
        Set partitions = partitionFields.stream().map(FieldSchema::getName).collect(Collectors.toSet());
        columns.removeIf(column -> partitions.contains(column.getName()));
    }
}

