/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.parquet;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordWriterProvider
implements RecordWriterProvider<HdfsSinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(ParquetRecordWriterProvider.class);
    private static final String EXTENSION = ".parquet";
    private final AvroData avroData;

    ParquetRecordWriterProvider(AvroData avroData) {
        this.avroData = avroData;
    }

    public String getExtension() {
        return EXTENSION;
    }

    public RecordWriter getRecordWriter(final HdfsSinkConnectorConfig conf, final String filename) {
        return new RecordWriter(){
            final CompressionCodecName compressionCodecName = CompressionCodecName.SNAPPY;
            final int blockSize = 0x10000000;
            final int pageSize = 65536;
            Path path = new Path(filename);
            org.apache.kafka.connect.data.Schema schema;
            ParquetWriter<GenericRecord> writer;

            public void write(SinkRecord record) {
                if (this.schema == null) {
                    this.schema = record.valueSchema();
                }
                if (this.writer == null) {
                    try {
                        log.info("Opening record writer for: {}", (Object)filename);
                        Schema avroSchema = ParquetRecordWriterProvider.this.avroData.fromConnectSchema(this.schema);
                        this.writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)this.path).withSchema(avroSchema).withCompressionCodec(this.compressionCodecName)).withRowGroupSize(0x10000000)).withPageSize(65536)).withDictionaryEncoding(true)).withConf(conf.getHadoopConfiguration())).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();
                        log.debug("Opened record writer for: {}", (Object)filename);
                    }
                    catch (IOException e) {
                        log.warn("Error creating {} for file '{}', {}, and schema {}: ", new Object[]{AvroParquetWriter.class.getSimpleName(), filename, this.compressionCodecName, this.schema, e});
                        throw new ConnectException((Throwable)e);
                    }
                }
                log.trace("Sink record: {}", (Object)record);
                Object value = ParquetRecordWriterProvider.this.avroData.fromConnectData(record.valueSchema(), record.value());
                try {
                    this.writer.write((Object)((GenericRecord)value));
                }
                catch (IOException e) {
                    throw new ConnectException((Throwable)e);
                }
            }

            public void close() {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException e) {
                        throw new ConnectException((Throwable)e);
                    }
                }
            }

            public void commit() {
            }
        };
    }
}

