/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.schema;

import io.confluent.connect.hdfs.schema.Compatibility;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaProjector;
import org.apache.kafka.connect.errors.SchemaProjectorException;
import org.apache.kafka.connect.sink.SinkRecord;

@Deprecated
public class SchemaUtils {
    public static Compatibility getCompatibility(String compatibilityString) {
        switch (compatibilityString) {
            case "BACKWARD": {
                return Compatibility.BACKWARD;
            }
            case "FORWARD": {
                return Compatibility.FORWARD;
            }
            case "FULL": {
                return Compatibility.FULL;
            }
        }
        return Compatibility.NONE;
    }

    public static boolean shouldChangeSchema(Schema valueSchema, Schema currentSchema, Compatibility compatibility) {
        if (currentSchema == null) {
            return true;
        }
        if ((valueSchema.version() == null || currentSchema.version() == null) && compatibility != Compatibility.NONE) {
            throw new SchemaProjectorException("Schema version required for " + compatibility.toString() + " compatibility");
        }
        switch (compatibility) {
            case BACKWARD: 
            case FULL: {
                return valueSchema.version().compareTo(currentSchema.version()) > 0;
            }
            case FORWARD: {
                return valueSchema.version().compareTo(currentSchema.version()) < 0;
            }
        }
        return !valueSchema.equals(currentSchema);
    }

    public static SinkRecord project(SinkRecord record, Schema currentSchema, Compatibility compatibility) {
        switch (compatibility) {
            case BACKWARD: 
            case FULL: 
            case FORWARD: {
                Schema sourceSchema = record.valueSchema();
                Object value = record.value();
                if (sourceSchema == currentSchema || sourceSchema.equals(currentSchema)) {
                    return record;
                }
                Object projected = SchemaProjector.project((Schema)sourceSchema, (Object)value, (Schema)currentSchema);
                return new SinkRecord(record.topic(), record.kafkaPartition().intValue(), record.keySchema(), record.key(), currentSchema, projected, record.kafkaOffset());
            }
        }
        return record;
    }
}

