/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.storage;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.storage.Storage;
import io.confluent.connect.hdfs.wal.FSWAL;
import io.confluent.connect.hdfs.wal.WAL;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsStorage
implements io.confluent.connect.storage.Storage<HdfsSinkConnectorConfig, List<FileStatus>>,
Storage {
    private static final Logger log = LoggerFactory.getLogger(HdfsStorage.class);
    private final FileSystem fs;
    private final HdfsSinkConnectorConfig conf;
    private final String url;

    protected HdfsStorage(HdfsSinkConnectorConfig conf, String url, FileSystem fs) {
        this.conf = conf;
        this.url = url;
        this.fs = fs;
    }

    public HdfsStorage(HdfsSinkConnectorConfig conf, String url) throws IOException {
        this.conf = conf;
        this.url = url;
        this.fs = FileSystem.newInstance((URI)URI.create(url), (Configuration)conf.getHadoopConfiguration());
    }

    public List<FileStatus> list(String path, PathFilter filter) {
        try {
            return Arrays.asList(this.fs.listStatus(new Path(path), filter));
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public List<FileStatus> list(String path) {
        try {
            return Arrays.asList(this.fs.listStatus(new Path(path)));
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public OutputStream append(String filename) {
        throw new UnsupportedOperationException();
    }

    public boolean create(String filename) {
        try {
            return this.fs.mkdirs(new Path(filename));
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public OutputStream create(String filename, boolean overwrite) {
        try {
            return this.fs.create(new Path(filename), overwrite);
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public OutputStream create(final String filename, final HdfsSinkConnectorConfig conf, final boolean overwrite) {
        final Path path = new Path(filename);
        try {
            return new OutputStream(){
                FileSystem fs;
                OutputStream file;
                {
                    this.fs = FileSystem.newInstance((URI)path.toUri(), (Configuration)conf.getHadoopConfiguration());
                    this.file = this.fs.create(new Path(filename), overwrite);
                }

                @Override
                public void write(int b) throws IOException {
                    this.file.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.file.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.file.write(b, off, len);
                }

                @Override
                public void flush() throws IOException {
                    this.file.flush();
                }

                @Override
                public void close() throws IOException {
                    try {
                        this.file.close();
                    }
                    finally {
                        try {
                            this.fs.close();
                        }
                        catch (Throwable t) {
                            log.error("Could not close FileSystem", t);
                        }
                    }
                }
            };
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public boolean exists(String filename) {
        try {
            return this.fs.exists(new Path(filename));
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public void commit(String tempFile, String committedFile) {
        this.renameFile(tempFile, committedFile);
    }

    public void delete(String filename) {
        try {
            this.fs.delete(new Path(filename), true);
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public void close() {
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException e) {
                throw new ConnectException((Throwable)e);
            }
        }
    }

    public WAL wal(String topicsDir, TopicPartition topicPart) {
        return new FSWAL(topicsDir, topicPart, this);
    }

    public HdfsSinkConnectorConfig conf() {
        return this.conf;
    }

    public String url() {
        return this.url;
    }

    private void renameFile(String sourcePath, String targetPath) {
        if (sourcePath.equals(targetPath)) {
            return;
        }
        try {
            Path srcPath = new Path(sourcePath);
            Path dstPath = new Path(targetPath);
            if (this.fs.exists(srcPath)) {
                this.fs.rename(srcPath, dstPath);
            }
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    public SeekableInput open(String filename, HdfsSinkConnectorConfig conf) {
        try {
            return new FsInput(new Path(filename), conf.getHadoopConfiguration());
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }
}

