/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.string;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringRecordWriterProvider
implements RecordWriterProvider<HdfsSinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(StringRecordWriterProvider.class);
    private static final String EXTENSION = ".txt";
    private static final int WRITER_BUFFER_SIZE = 131072;
    private final HdfsStorage storage;

    StringRecordWriterProvider(HdfsStorage storage) {
        this.storage = storage;
    }

    public String getExtension() {
        return EXTENSION;
    }

    public RecordWriter getRecordWriter(HdfsSinkConnectorConfig conf, final String filename) {
        return new RecordWriter(){
            final OutputStream out;
            final OutputStreamWriter streamWriter;
            final BufferedWriter writer;
            {
                this.out = StringRecordWriterProvider.this.storage.create(filename, true);
                this.streamWriter = new OutputStreamWriter(this.out, Charset.defaultCharset());
                this.writer = new BufferedWriter(this.streamWriter, 131072);
            }

            public void write(SinkRecord record) {
                log.trace("Sink record: {}", (Object)record.toString());
                try {
                    String value = (String)record.value();
                    this.writer.write(value);
                    this.writer.newLine();
                }
                catch (IOException e) {
                    throw new ConnectException((Throwable)e);
                }
            }

            public void commit() {
            }

            public void close() {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    throw new ConnectException((Throwable)e);
                }
            }
        };
    }
}

