/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.protobuf;

import com.google.protobuf.Message;
import io.confluent.connect.protobuf.ProtobufConverterConfig;
import io.confluent.connect.protobuf.ProtobufData;
import io.confluent.connect.protobuf.ProtobufDataConfig;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializerConfig;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;

public class ProtobufConverter
implements Converter {
    private SchemaRegistryClient schemaRegistry;
    private Serializer serializer;
    private Deserializer deserializer;
    private boolean isKey;
    private ProtobufData protobufData;

    public ProtobufConverter() {
    }

    public ProtobufConverter(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        ProtobufConverterConfig protobufConverterConfig = new ProtobufConverterConfig(configs);
        if (this.schemaRegistry == null) {
            this.schemaRegistry = SchemaRegistryClientFactory.newClient((List)protobufConverterConfig.getSchemaRegistryUrls(), (int)protobufConverterConfig.getMaxSchemasPerSubject(), Collections.singletonList(new ProtobufSchemaProvider()), configs, (Map)protobufConverterConfig.requestHeaders());
        }
        this.serializer = new Serializer(configs, this.schemaRegistry);
        this.deserializer = new Deserializer(configs, this.schemaRegistry);
        this.protobufData = new ProtobufData(new ProtobufDataConfig(configs));
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        try {
            ProtobufSchemaAndValue schemaAndValue = this.protobufData.fromConnectData(schema, value);
            Object v = schemaAndValue.getValue();
            if (v == null) {
                return null;
            }
            if (v instanceof Message) {
                return this.serializer.serialize(topic, this.isKey, (Message)v, schemaAndValue.getSchema());
            }
            throw new DataException("Unsupported object of class " + v.getClass().getName());
        }
        catch (SerializationException e) {
            throw new DataException(String.format("Failed to serialize Protobuf data from topic %s :", topic), (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            throw new ConfigException(String.format("Failed to access Protobuf data from topic %s : %s", topic, e.getMessage()));
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        try {
            ProtobufSchemaAndValue deserialized = this.deserializer.deserialize(topic, this.isKey, value);
            if (deserialized == null || deserialized.getValue() == null) {
                return SchemaAndValue.NULL;
            }
            Object object = deserialized.getValue();
            if (object instanceof Message) {
                Message message = (Message)object;
                return this.protobufData.toConnectData(deserialized.getSchema(), message);
            }
            throw new DataException(String.format("Unsupported type %s returned during deserialization of topic %s ", object.getClass().getName(), topic));
        }
        catch (SerializationException e) {
            throw new DataException(String.format("Failed to deserialize data for topic %s to Protobuf: ", topic), (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            throw new ConfigException(String.format("Failed to access Protobuf data from topic %s : %s", topic, e.getMessage()));
        }
    }

    private static class Deserializer
    extends AbstractKafkaProtobufDeserializer {
        public Deserializer(SchemaRegistryClient client) {
            this.schemaRegistry = client;
        }

        public Deserializer(Map<String, ?> configs, SchemaRegistryClient client) {
            this(client);
            this.configure(new KafkaProtobufDeserializerConfig(configs), null);
        }

        public ProtobufSchemaAndValue deserialize(String topic, boolean isKey, byte[] payload) {
            return this.deserializeWithSchemaAndVersion(topic, isKey, payload);
        }
    }

    private static class Serializer
    extends AbstractKafkaProtobufSerializer {
        public Serializer(SchemaRegistryClient client, boolean autoRegisterSchema) {
            this.schemaRegistry = client;
            this.autoRegisterSchema = autoRegisterSchema;
        }

        public Serializer(Map<String, ?> configs, SchemaRegistryClient client) {
            this(client, false);
            this.configure(new KafkaProtobufSerializerConfig(configs));
        }

        public byte[] serialize(String topic, boolean isKey, Message value, ProtobufSchema schema) {
            if (value == null) {
                return null;
            }
            return this.serializeImpl(this.getSubjectName(topic, isKey, value, (ParsedSchema)schema), topic, isKey, value, schema);
        }
    }
}

