/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.SSEAlgorithm;
import io.confluent.connect.s3.format.avro.AvroFormat;
import io.confluent.connect.s3.format.bytearray.ByteArrayFormat;
import io.confluent.connect.s3.format.json.JsonFormat;
import io.confluent.connect.s3.format.parquet.ParquetFormat;
import io.confluent.connect.s3.storage.CompressionType;
import io.confluent.connect.s3.storage.S3Storage;
import io.confluent.connect.storage.StorageSinkConnectorConfig;
import io.confluent.connect.storage.common.ComposableConfig;
import io.confluent.connect.storage.common.GenericRecommender;
import io.confluent.connect.storage.common.ParentValueRecommender;
import io.confluent.connect.storage.common.StorageCommonConfig;
import io.confluent.connect.storage.format.Format;
import io.confluent.connect.storage.partitioner.DailyPartitioner;
import io.confluent.connect.storage.partitioner.DefaultPartitioner;
import io.confluent.connect.storage.partitioner.FieldPartitioner;
import io.confluent.connect.storage.partitioner.HourlyPartitioner;
import io.confluent.connect.storage.partitioner.PartitionerConfig;
import io.confluent.connect.storage.partitioner.TimeBasedPartitioner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class S3SinkConnectorConfig
extends StorageSinkConnectorConfig {
    public static final String S3_BUCKET_CONFIG = "s3.bucket.name";
    public static final String S3_OBJECT_TAGGING_CONFIG = "s3.object.tagging";
    public static final boolean S3_OBJECT_TAGGING_DEFAULT = false;
    public static final String SSEA_CONFIG = "s3.ssea.name";
    public static final String SSEA_DEFAULT = "";
    public static final String SSE_CUSTOMER_KEY = "s3.sse.customer.key";
    public static final Password SSE_CUSTOMER_KEY_DEFAULT = new Password(null);
    public static final String SSE_KMS_KEY_ID_CONFIG = "s3.sse.kms.key.id";
    public static final String SSE_KMS_KEY_ID_DEFAULT = "";
    public static final String PART_SIZE_CONFIG = "s3.part.size";
    public static final int PART_SIZE_DEFAULT = 0x1900000;
    public static final String WAN_MODE_CONFIG = "s3.wan.mode";
    private static final boolean WAN_MODE_DEFAULT = false;
    public static final String CREDENTIALS_PROVIDER_CLASS_CONFIG = "s3.credentials.provider.class";
    public static final Class<? extends AWSCredentialsProvider> CREDENTIALS_PROVIDER_CLASS_DEFAULT = DefaultAWSCredentialsProviderChain.class;
    public static final String CREDENTIALS_PROVIDER_CONFIG_PREFIX = "s3.credentials.provider.class".substring(0, "s3.credentials.provider.class".lastIndexOf(".") + 1);
    public static final String AWS_ACCESS_KEY_ID_CONFIG = "aws.access.key.id";
    public static final String AWS_ACCESS_KEY_ID_DEFAULT = "";
    public static final String AWS_SECRET_ACCESS_KEY_CONFIG = "aws.secret.access.key";
    public static final Password AWS_SECRET_ACCESS_KEY_DEFAULT = new Password(null);
    public static final String REGION_CONFIG = "s3.region";
    public static final String REGION_DEFAULT = Regions.DEFAULT_REGION.getName();
    public static final String ACL_CANNED_CONFIG = "s3.acl.canned";
    public static final String ACL_CANNED_DEFAULT = null;
    public static final String COMPRESSION_TYPE_CONFIG = "s3.compression.type";
    public static final String COMPRESSION_TYPE_DEFAULT = "none";
    public static final String COMPRESSION_LEVEL_CONFIG = "s3.compression.level";
    public static final int COMPRESSION_LEVEL_DEFAULT = -1;
    private static final CompressionLevelValidator COMPRESSION_LEVEL_VALIDATOR = new CompressionLevelValidator();
    public static final String S3_PART_RETRIES_CONFIG = "s3.part.retries";
    public static final int S3_PART_RETRIES_DEFAULT = 3;
    public static final String FORMAT_BYTEARRAY_EXTENSION_CONFIG = "format.bytearray.extension";
    public static final String FORMAT_BYTEARRAY_EXTENSION_DEFAULT = ".bin";
    public static final String FORMAT_BYTEARRAY_LINE_SEPARATOR_CONFIG = "format.bytearray.separator";
    public static final String FORMAT_BYTEARRAY_LINE_SEPARATOR_DEFAULT = System.lineSeparator();
    public static final String S3_PROXY_URL_CONFIG = "s3.proxy.url";
    public static final String S3_PROXY_URL_DEFAULT = "";
    public static final String S3_PROXY_USER_CONFIG = "s3.proxy.user";
    public static final String S3_PROXY_USER_DEFAULT = null;
    public static final String S3_PROXY_PASS_CONFIG = "s3.proxy.password";
    public static final Password S3_PROXY_PASS_DEFAULT = new Password(null);
    public static final String HEADERS_USE_EXPECT_CONTINUE_CONFIG = "s3.http.send.expect.continue";
    public static final boolean HEADERS_USE_EXPECT_CONTINUE_DEFAULT = true;
    public static final String BEHAVIOR_ON_NULL_VALUES_CONFIG = "behavior.on.null.values";
    public static final String BEHAVIOR_ON_NULL_VALUES_DEFAULT = BehaviorOnNullValues.FAIL.toString();
    public static final int S3_RETRY_MAX_BACKOFF_TIME_MS = (int)TimeUnit.HOURS.toMillis(24L);
    public static final String S3_RETRY_BACKOFF_CONFIG = "s3.retry.backoff.ms";
    public static final int S3_RETRY_BACKOFF_DEFAULT = 200;
    public static final String S3_PATH_STYLE_ACCESS_ENABLED_CONFIG = "s3.path.style.access.enabled";
    public static final boolean S3_PATH_STYLE_ACCESS_ENABLED_DEFAULT = true;
    public static final String STORE_KAFKA_KEYS_CONFIG = "store.kafka.keys";
    public static final String STORE_KAFKA_HEADERS_CONFIG = "store.kafka.headers";
    public static final String KEYS_FORMAT_CLASS_CONFIG = "keys.format.class";
    public static final Class<? extends Format> KEYS_FORMAT_CLASS_DEFAULT = AvroFormat.class;
    public static final String HEADERS_FORMAT_CLASS_CONFIG = "headers.format.class";
    public static final Class<? extends Format> HEADERS_FORMAT_CLASS_DEFAULT = AvroFormat.class;
    private final String name;
    private final Map<String, ComposableConfig> propertyToConfig = new HashMap<String, ComposableConfig>();
    private final Set<AbstractConfig> allConfigs = new HashSet<AbstractConfig>();
    private static final GenericRecommender STORAGE_CLASS_RECOMMENDER = new GenericRecommender();
    private static final GenericRecommender FORMAT_CLASS_RECOMMENDER = new GenericRecommender();
    private static final GenericRecommender PARTITIONER_CLASS_RECOMMENDER = new GenericRecommender();
    private static final ParentValueRecommender AVRO_COMPRESSION_RECOMMENDER = new ParentValueRecommender("format.class", AvroFormat.class, (Object[])AVRO_SUPPORTED_CODECS);
    private static final ParquetCodecRecommender PARQUET_COMPRESSION_RECOMMENDER = new ParquetCodecRecommender();
    private static final Collection<Object> FORMAT_CLASS_VALID_VALUES = Arrays.asList(AvroFormat.class, JsonFormat.class, ByteArrayFormat.class, ParquetFormat.class);
    private static final Collection<Object> HEADERS_FORMAT_CLASS_VALID_VALUES = Arrays.asList(AvroFormat.class, JsonFormat.class, ParquetFormat.class);
    private static final ParentValueRecommender KEYS_FORMAT_CLASS_RECOMMENDER = new ParentValueRecommender("store.kafka.keys", (Object)true, FORMAT_CLASS_VALID_VALUES);
    private static final ParentValueRecommender HEADERS_FORMAT_CLASS_RECOMMENDER = new ParentValueRecommender("store.kafka.headers", (Object)true, HEADERS_FORMAT_CLASS_VALID_VALUES);

    public static ConfigDef newConfigDef() {
        ConfigDef configDef = StorageSinkConnectorConfig.newConfigDef((ConfigDef.Recommender)FORMAT_CLASS_RECOMMENDER, (ConfigDef.Recommender)AVRO_COMPRESSION_RECOMMENDER);
        String connectorGroup = "Connector";
        int latestOrderInGroup = configDef.configKeys().values().stream().filter(c -> "Connector".equalsIgnoreCase(c.group)).map(c -> c.orderInGroup).max(Integer::compare).orElse(0);
        StorageSinkConnectorConfig.enableParquetConfig((ConfigDef)configDef, (ConfigDef.Recommender)PARQUET_COMPRESSION_RECOMMENDER, (String)"Connector", (int)latestOrderInGroup);
        String group = "S3";
        int orderInGroup = 0;
        configDef.define(S3_BUCKET_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "The S3 Bucket.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Bucket");
        configDef.define(S3_OBJECT_TAGGING_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Tag S3 objects with start and end offsets, as well as record count.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Object Tagging");
        configDef.define(REGION_CONFIG, ConfigDef.Type.STRING, (Object)REGION_DEFAULT, (ConfigDef.Validator)new RegionValidator(), ConfigDef.Importance.MEDIUM, "The AWS region to be used the connector.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "AWS region", (ConfigDef.Recommender)new RegionRecommender());
        configDef.define(PART_SIZE_CONFIG, ConfigDef.Type.INT, (Object)0x1900000, (ConfigDef.Validator)new PartRange(), ConfigDef.Importance.HIGH, "The Part Size in S3 Multi-part Uploads.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Part Size");
        configDef.define(CREDENTIALS_PROVIDER_CLASS_CONFIG, ConfigDef.Type.CLASS, CREDENTIALS_PROVIDER_CLASS_DEFAULT, (ConfigDef.Validator)new CredentialsProviderValidator(), ConfigDef.Importance.LOW, "Credentials provider or provider chain to use for authentication to AWS. By default the connector uses ``" + DefaultAWSCredentialsProviderChain.class.getSimpleName() + "``.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "AWS Credentials Provider Class");
        configDef.define(AWS_ACCESS_KEY_ID_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The AWS access key ID used to authenticate personal AWS credentials such as IAM credentials. Use only if you do not wish to authenticate by using a credentials provider class via ``s3.credentials.provider.class``", "S3", ++orderInGroup, ConfigDef.Width.LONG, "AWS Access Key ID");
        configDef.define(AWS_SECRET_ACCESS_KEY_CONFIG, ConfigDef.Type.PASSWORD, (Object)AWS_SECRET_ACCESS_KEY_DEFAULT, ConfigDef.Importance.HIGH, "The secret access key used to authenticate personal AWS credentials such as IAM credentials. Use only if you do not wish to authenticate by using a credentials provider class via ``s3.credentials.provider.class``", "S3", ++orderInGroup, ConfigDef.Width.LONG, "AWS Secret Access Key");
        ArrayList<String> validSsea = new ArrayList<String>(SSEAlgorithm.values().length + 1);
        validSsea.add("");
        for (SSEAlgorithm algo : SSEAlgorithm.values()) {
            validSsea.add(algo.toString());
        }
        configDef.define(SSEA_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])validSsea.toArray(new String[validSsea.size()])), ConfigDef.Importance.LOW, "The S3 Server Side Encryption Algorithm.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Server Side Encryption Algorithm", (ConfigDef.Recommender)new SseAlgorithmRecommender());
        configDef.define(SSE_CUSTOMER_KEY, ConfigDef.Type.PASSWORD, (Object)SSE_CUSTOMER_KEY_DEFAULT, ConfigDef.Importance.LOW, "The S3 Server Side Encryption Customer-Provided Key (SSE-C).", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Server Side Encryption Customer-Provided Key (SSE-C)");
        configDef.define(SSE_KMS_KEY_ID_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "The name of the AWS Key Management Service (AWS-KMS) key to be used for server side encryption of the S3 objects. No encryption is used when no key is provided, but it is enabled when ``" + SSEAlgorithm.KMS + "`` is specified as encryption algorithm with a valid key name.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Server Side Encryption Key", (ConfigDef.Recommender)new SseKmsKeyIdRecommender());
        configDef.define(ACL_CANNED_CONFIG, ConfigDef.Type.STRING, (Object)ACL_CANNED_DEFAULT, (ConfigDef.Validator)new CannedAclValidator(), ConfigDef.Importance.LOW, "An S3 canned ACL header value to apply when writing objects.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Canned ACL");
        configDef.define(WAN_MODE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Use S3 accelerated endpoint.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 accelerated endpoint enabled");
        configDef.define(COMPRESSION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)COMPRESSION_TYPE_DEFAULT, (ConfigDef.Validator)new CompressionTypeValidator(), ConfigDef.Importance.LOW, "Compression type for files written to S3. Applied when using JsonFormat or ByteArrayFormat. Available values: none, gzip.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "Compression type");
        configDef.define(COMPRESSION_LEVEL_CONFIG, ConfigDef.Type.INT, (Object)-1, (ConfigDef.Validator)COMPRESSION_LEVEL_VALIDATOR, ConfigDef.Importance.LOW, "Compression level for files written to S3. Applied when using JsonFormat or ByteArrayFormat. ", "S3", ++orderInGroup, ConfigDef.Width.LONG, "Compression Level", (ConfigDef.Recommender)COMPRESSION_LEVEL_VALIDATOR);
        configDef.define(S3_PART_RETRIES_CONFIG, ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "Maximum number of retry attempts for failed requests. Zero means no retries. The actual number of attempts is determined by the S3 client based on multiple factors including, but not limited to: the value of this parameter, type of exception occurred, and throttling settings of the underlying S3 client.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Part Upload Retries");
        configDef.define(S3_RETRY_BACKOFF_CONFIG, ConfigDef.Type.LONG, (Object)200, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "How long to wait in milliseconds before attempting the first retry of a failed S3 request. Upon a failure, this connector may wait up to twice as long as the previous wait, up to the maximum number of retries. This avoids retrying in a tight loop under failure scenarios.", "S3", ++orderInGroup, ConfigDef.Width.SHORT, "Retry Backoff (ms)");
        configDef.define(FORMAT_BYTEARRAY_EXTENSION_CONFIG, ConfigDef.Type.STRING, (Object)FORMAT_BYTEARRAY_EXTENSION_DEFAULT, ConfigDef.Importance.LOW, String.format("Output file extension for ByteArrayFormat. Defaults to ``%s``.", FORMAT_BYTEARRAY_EXTENSION_DEFAULT), "S3", ++orderInGroup, ConfigDef.Width.LONG, "Output file extension for ByteArrayFormat");
        configDef.define(FORMAT_BYTEARRAY_LINE_SEPARATOR_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "String inserted between records for ByteArrayFormat. Defaults to ``System.lineSeparator()`` and may contain escape sequences like ``\\n``. An input record that contains the line separator will look like multiple records in the output S3 object.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "Line separator ByteArrayFormat");
        configDef.define(S3_PROXY_URL_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "S3 Proxy settings encoded in URL syntax. This property is meant to be used only if you need to access S3 through a proxy.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Proxy Settings");
        configDef.define(S3_PROXY_USER_CONFIG, ConfigDef.Type.STRING, (Object)S3_PROXY_USER_DEFAULT, ConfigDef.Importance.LOW, "S3 Proxy User. This property is meant to be used only if you need to access S3 through a proxy. Using ``s3.proxy.user`` instead of embedding the username and password in ``s3.proxy.url`` allows the password to be hidden in the logs.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Proxy User");
        configDef.define(S3_PROXY_PASS_CONFIG, ConfigDef.Type.PASSWORD, (Object)S3_PROXY_PASS_DEFAULT, ConfigDef.Importance.LOW, "S3 Proxy Password. This property is meant to be used only if you need to access S3 through a proxy. Using ``s3.proxy.password`` instead of embedding the username and password in ``s3.proxy.url`` allows the password to be hidden in the logs.", "S3", ++orderInGroup, ConfigDef.Width.LONG, "S3 Proxy Password");
        configDef.define(HEADERS_USE_EXPECT_CONTINUE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable or disable use of the HTTP/1.1 handshake using EXPECT: 100-CONTINUE during multi-part upload. If true, the client will wait for a 100 (CONTINUE) response before sending the request body. Else, the client uploads the entire request body without checking if the server is willing to accept the request.", "S3", ++orderInGroup, ConfigDef.Width.SHORT, "S3 HTTP Send Uses Expect Continue");
        configDef.define(BEHAVIOR_ON_NULL_VALUES_CONFIG, ConfigDef.Type.STRING, (Object)BEHAVIOR_ON_NULL_VALUES_DEFAULT, BehaviorOnNullValues.VALIDATOR, ConfigDef.Importance.LOW, "How to handle records with a null value (i.e. Kafka tombstone records). Valid options are 'ignore' and 'fail'.", "S3", ++orderInGroup, ConfigDef.Width.SHORT, "Behavior for null-valued records");
        group = "Keys and Headers";
        orderInGroup = 0;
        configDef.define(STORE_KAFKA_KEYS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Enable or disable writing keys to storage.", "Keys and Headers", ++orderInGroup, ConfigDef.Width.SHORT, "Store kafka keys", Collections.singletonList(KEYS_FORMAT_CLASS_CONFIG));
        configDef.define(STORE_KAFKA_HEADERS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Enable or disable writing headers to storage.", "Keys and Headers", ++orderInGroup, ConfigDef.Width.SHORT, "Store kafka headers", Collections.singletonList(HEADERS_FORMAT_CLASS_CONFIG));
        configDef.define(KEYS_FORMAT_CLASS_CONFIG, ConfigDef.Type.CLASS, KEYS_FORMAT_CLASS_DEFAULT, ConfigDef.Importance.LOW, "The format class to use when writing keys to the store.", "Keys and Headers", ++orderInGroup, ConfigDef.Width.NONE, "Keys format class", (ConfigDef.Recommender)KEYS_FORMAT_CLASS_RECOMMENDER);
        configDef.define(HEADERS_FORMAT_CLASS_CONFIG, ConfigDef.Type.CLASS, HEADERS_FORMAT_CLASS_DEFAULT, ConfigDef.Importance.LOW, "The format class to use when writing headers to the store.", "Keys and Headers", ++orderInGroup, ConfigDef.Width.NONE, "Headers format class", (ConfigDef.Recommender)HEADERS_FORMAT_CLASS_RECOMMENDER);
        configDef.define(S3_PATH_STYLE_ACCESS_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Specifies whether or not to enable path style access to the bucket used by the connector", "Keys and Headers", ++orderInGroup, ConfigDef.Width.SHORT, "Enable Path Style Access to S3");
        return configDef;
    }

    public S3SinkConnectorConfig(Map<String, String> props) {
        this(S3SinkConnectorConfig.newConfigDef(), props);
    }

    protected S3SinkConnectorConfig(ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
        ConfigDef storageCommonConfigDef = StorageCommonConfig.newConfigDef((ConfigDef.Recommender)STORAGE_CLASS_RECOMMENDER);
        StorageCommonConfig commonConfig = new StorageCommonConfig(storageCommonConfigDef, this.originalsStrings());
        ConfigDef partitionerConfigDef = PartitionerConfig.newConfigDef((ConfigDef.Recommender)PARTITIONER_CLASS_RECOMMENDER);
        PartitionerConfig partitionerConfig = new PartitionerConfig(partitionerConfigDef, this.originalsStrings());
        this.name = S3SinkConnectorConfig.parseName(this.originalsStrings());
        this.addToGlobal((AbstractConfig)partitionerConfig);
        this.addToGlobal((AbstractConfig)commonConfig);
        this.addToGlobal((AbstractConfig)this);
        this.validateTimezone();
    }

    private void validateTimezone() {
        String timezone = this.getString("timezone");
        long rotateScheduleIntervalMs = this.getLong("rotate.schedule.interval.ms");
        if (rotateScheduleIntervalMs > 0L && timezone.isEmpty()) {
            throw new ConfigException(String.format("%s configuration must be set when using %s", "timezone", "rotate.schedule.interval.ms"));
        }
    }

    private void addToGlobal(AbstractConfig config) {
        this.allConfigs.add(config);
        this.addConfig(config.values(), (ComposableConfig)config);
    }

    private void addConfig(Map<String, ?> parsedProps, ComposableConfig config) {
        for (String key : parsedProps.keySet()) {
            this.propertyToConfig.put(key, config);
        }
    }

    public String getBucketName() {
        return this.getString(S3_BUCKET_CONFIG);
    }

    public String getSsea() {
        return this.getString(SSEA_CONFIG);
    }

    public String getSseCustomerKey() {
        return this.getPassword(SSE_CUSTOMER_KEY).value();
    }

    public String getSseKmsKeyId() {
        return this.getString(SSE_KMS_KEY_ID_CONFIG);
    }

    public boolean useExpectContinue() {
        return this.getBoolean(HEADERS_USE_EXPECT_CONTINUE_CONFIG);
    }

    public CannedAccessControlList getCannedAcl() {
        return CannedAclValidator.ACLS_BY_HEADER_VALUE.get(this.getString(ACL_CANNED_CONFIG));
    }

    public int getPartSize() {
        return this.getInt(PART_SIZE_CONFIG);
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        try {
            AWSCredentialsProvider provider = (AWSCredentialsProvider)this.getClass(CREDENTIALS_PROVIDER_CLASS_CONFIG).newInstance();
            if (provider instanceof Configurable) {
                Map configs = this.originalsWithPrefix(CREDENTIALS_PROVIDER_CONFIG_PREFIX);
                configs.remove(CREDENTIALS_PROVIDER_CLASS_CONFIG.substring(CREDENTIALS_PROVIDER_CONFIG_PREFIX.length()));
                ((Configurable)provider).configure(configs);
            }
            return provider;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConnectException("Invalid class for: s3.credentials.provider.class", (Throwable)e);
        }
    }

    public CompressionType getCompressionType() {
        return CompressionType.forName(this.getString(COMPRESSION_TYPE_CONFIG));
    }

    public int getCompressionLevel() {
        return this.getInt(COMPRESSION_LEVEL_CONFIG);
    }

    public CompressionCodecName parquetCompressionCodecName() {
        return COMPRESSION_TYPE_DEFAULT.equalsIgnoreCase(this.getString("parquet.codec")) ? CompressionCodecName.fromConf(null) : CompressionCodecName.fromConf((String)this.getString("parquet.codec"));
    }

    public boolean storeKafkaKeys() {
        return this.getBoolean(STORE_KAFKA_KEYS_CONFIG);
    }

    public boolean storeKafkaHeaders() {
        return this.getBoolean(STORE_KAFKA_HEADERS_CONFIG);
    }

    public Class keysFormatClass() {
        return this.getClass(KEYS_FORMAT_CLASS_CONFIG);
    }

    public Class headersFormatClass() {
        return this.getClass(HEADERS_FORMAT_CLASS_CONFIG);
    }

    public Class formatClass() {
        return this.getClass("format.class");
    }

    public int getS3PartRetries() {
        return this.getInt(S3_PART_RETRIES_CONFIG);
    }

    public String getByteArrayExtension() {
        return this.getString(FORMAT_BYTEARRAY_EXTENSION_CONFIG);
    }

    public String getFormatByteArrayLineSeparator() {
        if (this.originalsStrings().containsKey(FORMAT_BYTEARRAY_LINE_SEPARATOR_CONFIG)) {
            return (String)this.originalsStrings().get(FORMAT_BYTEARRAY_LINE_SEPARATOR_CONFIG);
        }
        return FORMAT_BYTEARRAY_LINE_SEPARATOR_DEFAULT;
    }

    protected static String parseName(Map<String, String> props) {
        String nameProp = props.get("name");
        return nameProp != null ? nameProp : "S3-sink";
    }

    public String getName() {
        return this.name;
    }

    public Object get(String key) {
        ComposableConfig config = this.propertyToConfig.get(key);
        if (config == null) {
            throw new ConfigException(String.format("Unknown configuration '%s'", key));
        }
        return config == this ? super.get(key) : config.get(key);
    }

    public Map<String, ?> plainValues() {
        HashMap map = new HashMap();
        for (AbstractConfig config : this.allConfigs) {
            map.putAll(config.values());
        }
        return map;
    }

    public static ConfigDef getConfig() {
        HashSet<String> skip = new HashSet<String>();
        skip.add("shutdown.timeout.ms");
        ConfigDef visible = new ConfigDef();
        S3SinkConnectorConfig.addAllConfigKeys(visible, S3SinkConnectorConfig.newConfigDef(), skip);
        S3SinkConnectorConfig.addAllConfigKeys(visible, StorageCommonConfig.newConfigDef((ConfigDef.Recommender)STORAGE_CLASS_RECOMMENDER), skip);
        S3SinkConnectorConfig.addAllConfigKeys(visible, PartitionerConfig.newConfigDef((ConfigDef.Recommender)PARTITIONER_CLASS_RECOMMENDER), skip);
        return visible;
    }

    private static void addAllConfigKeys(ConfigDef container, ConfigDef other, Set<String> skip) {
        for (ConfigDef.ConfigKey key : other.configKeys().values()) {
            if (skip == null || skip.contains(key.name)) continue;
            container.define(key);
        }
    }

    public String nullValueBehavior() {
        return this.getString(BEHAVIOR_ON_NULL_VALUES_CONFIG);
    }

    public static void main(String[] args) {
        System.out.println(S3SinkConnectorConfig.getConfig().toEnrichedRst());
    }

    static {
        STORAGE_CLASS_RECOMMENDER.addValidValues(Collections.singletonList(S3Storage.class));
        FORMAT_CLASS_RECOMMENDER.addValidValues(FORMAT_CLASS_VALID_VALUES);
        PARTITIONER_CLASS_RECOMMENDER.addValidValues(Arrays.asList(DefaultPartitioner.class, HourlyPartitioner.class, DailyPartitioner.class, TimeBasedPartitioner.class, FieldPartitioner.class));
    }

    public static enum BehaviorOnNullValues {
        IGNORE,
        FAIL;

        public static final ConfigDef.Validator VALIDATOR;

        public static String[] names() {
            BehaviorOnNullValues[] behaviors = BehaviorOnNullValues.values();
            String[] result = new String[behaviors.length];
            for (int i = 0; i < behaviors.length; ++i) {
                result[i] = behaviors[i].toString();
            }
            return result;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALIDATOR = new ConfigDef.Validator(){
                private final ConfigDef.ValidString validator = ConfigDef.ValidString.in((String[])BehaviorOnNullValues.names());

                public void ensureValid(String name, Object value) {
                    if (value instanceof String) {
                        value = ((String)value).toLowerCase(Locale.ROOT);
                    }
                    this.validator.ensureValid(name, value);
                }

                public String toString() {
                    return this.validator.toString();
                }
            };
        }
    }

    public static class SseKmsKeyIdRecommender
    implements ConfigDef.Recommender {
        public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
            return new LinkedList<Object>();
        }

        public boolean visible(String name, Map<String, Object> connectorConfigs) {
            return SSEAlgorithm.KMS.toString().equalsIgnoreCase((String)connectorConfigs.get(S3SinkConnectorConfig.SSEA_CONFIG));
        }
    }

    private static class SseAlgorithmRecommender
    implements ConfigDef.Recommender {
        private SseAlgorithmRecommender() {
        }

        public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
            List<SSEAlgorithm> list = Arrays.asList(SSEAlgorithm.values());
            return new ArrayList<SSEAlgorithm>(list);
        }

        public boolean visible(String name, Map<String, Object> connectorConfigs) {
            return true;
        }
    }

    private static class CredentialsProviderValidator
    implements ConfigDef.Validator {
        private CredentialsProviderValidator() {
        }

        public void ensureValid(String name, Object provider) {
            if (provider != null && provider instanceof Class && AWSCredentialsProvider.class.isAssignableFrom((Class)provider)) {
                return;
            }
            throw new ConfigException(name, provider, "Class must extend: " + AWSCredentialsProvider.class);
        }

        public String toString() {
            return "Any class implementing: " + AWSCredentialsProvider.class;
        }
    }

    private static class CannedAclValidator
    implements ConfigDef.Validator {
        public static final Map<String, CannedAccessControlList> ACLS_BY_HEADER_VALUE = new HashMap<String, CannedAccessControlList>();
        public static final String ALLOWED_VALUES;

        private CannedAclValidator() {
        }

        public void ensureValid(String name, Object cannedAcl) {
            if (cannedAcl == null) {
                return;
            }
            String aclStr = ((String)cannedAcl).trim();
            if (!ACLS_BY_HEADER_VALUE.containsKey(aclStr)) {
                throw new ConfigException(name, cannedAcl, "Value must be one of: " + ALLOWED_VALUES);
            }
        }

        public String toString() {
            return "[" + ALLOWED_VALUES + "]";
        }

        static {
            ArrayList<String> aclHeaderValues = new ArrayList<String>();
            for (CannedAccessControlList acl : CannedAccessControlList.values()) {
                ACLS_BY_HEADER_VALUE.put(acl.toString(), acl);
                aclHeaderValues.add(acl.toString());
            }
            ALLOWED_VALUES = Utils.join(aclHeaderValues, (String)", ");
        }
    }

    private static class ParquetCodecRecommender
    extends ParentValueRecommender
    implements ConfigDef.Validator {
        public static final Map<String, CompressionCodecName> TYPES_BY_NAME = Arrays.stream(CompressionCodecName.values()).filter(c -> !CompressionCodecName.UNCOMPRESSED.equals(c)).collect(Collectors.toMap(c -> c.name().toLowerCase(), Function.identity()));
        public static final List<String> ALLOWED_VALUES;

        public ParquetCodecRecommender() {
            super("format.class", ParquetFormat.class, ALLOWED_VALUES.toArray());
        }

        public void ensureValid(String name, Object compressionCodecName) {
            String compressionCodecNameString = ((String)compressionCodecName).trim();
            if (!TYPES_BY_NAME.containsKey(compressionCodecNameString)) {
                throw new ConfigException(name, compressionCodecName, "Value must be one of: " + ALLOWED_VALUES);
            }
        }

        public String toString() {
            return "[" + Utils.join(ALLOWED_VALUES, (String)", ") + "]";
        }

        static {
            TYPES_BY_NAME.put(S3SinkConnectorConfig.COMPRESSION_TYPE_DEFAULT, CompressionCodecName.UNCOMPRESSED);
            ALLOWED_VALUES = new ArrayList<String>(TYPES_BY_NAME.keySet());
            Collections.reverse(ALLOWED_VALUES);
        }
    }

    private static class CompressionLevelValidator
    implements ConfigDef.Validator,
    ConfigDef.Recommender {
        private static final int MIN = -1;
        private static final int MAX = 9;
        private static final ConfigDef.Range validRange = ConfigDef.Range.between((Number)-1, (Number)9);

        private CompressionLevelValidator() {
        }

        public void ensureValid(String name, Object compressionLevel) {
            validRange.ensureValid(name, compressionLevel);
        }

        public String toString() {
            return "-1 for system default, or " + validRange.toString() + " for levels between no compression and best compression";
        }

        public List<Object> validValues(String s, Map<String, Object> map) {
            return IntStream.range(-1, 9).boxed().collect(Collectors.toList());
        }

        public boolean visible(String s, Map<String, Object> map) {
            return true;
        }
    }

    private static class CompressionTypeValidator
    implements ConfigDef.Validator {
        public static final Map<String, CompressionType> TYPES_BY_NAME = new HashMap<String, CompressionType>();
        public static final String ALLOWED_VALUES;

        private CompressionTypeValidator() {
        }

        public void ensureValid(String name, Object compressionType) {
            String compressionTypeString = ((String)compressionType).trim();
            if (!TYPES_BY_NAME.containsKey(compressionTypeString)) {
                throw new ConfigException(name, compressionType, "Value must be one of: " + ALLOWED_VALUES);
            }
        }

        public String toString() {
            return "[" + ALLOWED_VALUES + "]";
        }

        static {
            ArrayList<String> names = new ArrayList<String>();
            for (CompressionType compressionType : CompressionType.values()) {
                TYPES_BY_NAME.put(compressionType.name, compressionType);
                names.add(compressionType.name);
            }
            ALLOWED_VALUES = Utils.join(names, (String)", ");
        }
    }

    private static class RegionValidator
    implements ConfigDef.Validator {
        private RegionValidator() {
        }

        public void ensureValid(String name, Object region) {
            String regionStr = ((String)region).toLowerCase().trim();
            if (RegionUtils.getRegion((String)regionStr) == null) {
                throw new ConfigException(name, region, "Value must be one of: " + Utils.join((Collection)RegionUtils.getRegions(), (String)", "));
            }
        }

        public String toString() {
            return "[" + Utils.join((Collection)RegionUtils.getRegions(), (String)", ") + "]";
        }
    }

    private static class RegionRecommender
    implements ConfigDef.Recommender {
        private RegionRecommender() {
        }

        public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
            return new ArrayList<Object>(RegionUtils.getRegions());
        }

        public boolean visible(String name, Map<String, Object> connectorConfigs) {
            return true;
        }
    }

    private static class PartRange
    implements ConfigDef.Validator {
        final int min = 0x500000;
        final int max = Integer.MAX_VALUE;

        private PartRange() {
        }

        public void ensureValid(String name, Object value) {
            if (value == null) {
                throw new ConfigException(name, value, "Part size must be non-null");
            }
            Number number = (Number)value;
            if (number.longValue() < 0x500000L) {
                throw new ConfigException(name, value, "Part size must be at least: 5242880 bytes (5MB)");
            }
            if (number.longValue() > Integer.MAX_VALUE) {
                throw new ConfigException(name, value, "Part size must be no more: 2147483647 bytes (~2GB)");
            }
        }

        public String toString() {
            return "[5242880,...,2147483647]";
        }
    }
}

