/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.storage;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedBackoffStrategies;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.SetObjectTaggingRequest;
import com.amazonaws.services.s3.model.Tag;
import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.format.parquet.ParquetFormat;
import io.confluent.connect.s3.storage.S3OutputStream;
import io.confluent.connect.s3.storage.S3ParquetOutputStream;
import io.confluent.connect.s3.util.S3ProxyConfig;
import io.confluent.connect.s3.util.Version;
import io.confluent.connect.storage.Storage;
import io.confluent.connect.storage.common.util.StringUtils;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.file.SeekableInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Storage
implements Storage<S3SinkConnectorConfig, ObjectListing> {
    private static final Logger log = LoggerFactory.getLogger(S3Storage.class);
    private final String url;
    private final String bucketName;
    private final AmazonS3 s3;
    private final S3SinkConnectorConfig conf;
    private static final String VERSION_FORMAT = "APN/1.0 Confluent/1.0 KafkaS3Connector/%s";

    public S3Storage(S3SinkConnectorConfig conf, String url) {
        this.url = url;
        this.conf = conf;
        this.bucketName = conf.getBucketName();
        this.s3 = this.newS3Client(conf);
    }

    public AmazonS3 newS3Client(S3SinkConnectorConfig config) {
        ClientConfiguration clientConfiguration = this.newClientConfiguration(config);
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withAccelerateModeEnabled(config.getBoolean("s3.wan.mode"))).withPathStyleAccessEnabled(config.getBoolean("s3.path.style.access.enabled"))).withCredentials(this.newCredentialsProvider(config))).withClientConfiguration(clientConfiguration);
        String region = config.getString("s3.region");
        builder = StringUtils.isBlank((String)this.url) ? ("us-east-1".equals(region) ? (AmazonS3ClientBuilder)builder.withRegion(Regions.US_EAST_1) : (AmazonS3ClientBuilder)builder.withRegion(region)) : (AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.url, region));
        return (AmazonS3)builder.build();
    }

    public S3Storage(S3SinkConnectorConfig conf, String url, String bucketName, AmazonS3 s3) {
        this.url = url;
        this.conf = conf;
        this.bucketName = bucketName;
        this.s3 = s3;
    }

    public ClientConfiguration newClientConfiguration(S3SinkConnectorConfig config) {
        String version = String.format(VERSION_FORMAT, Version.getVersion());
        ClientConfiguration clientConfiguration = PredefinedClientConfigurations.defaultConfig();
        clientConfiguration.withUserAgentPrefix(version).withRetryPolicy(this.newFullJitterRetryPolicy(config));
        if (StringUtils.isNotBlank((String)config.getString("s3.proxy.url"))) {
            S3ProxyConfig proxyConfig = new S3ProxyConfig(config);
            clientConfiguration.withProtocol(proxyConfig.protocol()).withProxyHost(proxyConfig.host()).withProxyPort(proxyConfig.port()).withProxyUsername(proxyConfig.user()).withProxyPassword(proxyConfig.pass());
        }
        clientConfiguration.withUseExpectContinue(config.useExpectContinue());
        return clientConfiguration;
    }

    protected RetryPolicy newFullJitterRetryPolicy(S3SinkConnectorConfig config) {
        PredefinedBackoffStrategies.FullJitterBackoffStrategy backoffStrategy = new PredefinedBackoffStrategies.FullJitterBackoffStrategy(config.getLong("s3.retry.backoff.ms").intValue(), S3SinkConnectorConfig.S3_RETRY_MAX_BACKOFF_TIME_MS);
        RetryPolicy retryPolicy = new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, (RetryPolicy.BackoffStrategy)backoffStrategy, this.conf.getS3PartRetries(), false);
        return retryPolicy;
    }

    protected AWSCredentialsProvider newCredentialsProvider(S3SinkConnectorConfig config) {
        String accessKeyId = config.getString("aws.access.key.id");
        String secretKey = config.getPassword("aws.secret.access.key").value();
        if (StringUtils.isNotBlank((String)accessKeyId) && StringUtils.isNotBlank((String)secretKey)) {
            log.info("Returning new credentials provider using the access key id and the secret access key that were directly supplied through the connector's configuration");
            BasicAWSCredentials basicCredentials = new BasicAWSCredentials(accessKeyId, secretKey);
            return new AWSStaticCredentialsProvider((AWSCredentials)basicCredentials);
        }
        log.info("Returning new credentials provider based on the configured credentials provider class");
        return config.getCredentialsProvider();
    }

    public boolean exists(String name) {
        return StringUtils.isNotBlank((String)name) && this.s3.doesObjectExist(this.bucketName, name);
    }

    public boolean bucketExists() {
        return StringUtils.isNotBlank((String)this.bucketName) && this.s3.doesBucketExistV2(this.bucketName);
    }

    public boolean create(String name) {
        throw new UnsupportedOperationException();
    }

    public OutputStream create(String path, S3SinkConnectorConfig conf, boolean overwrite) {
        return this.create(path, overwrite, this.conf.getClass("format.class"));
    }

    public S3OutputStream create(String path, boolean overwrite, Class<?> formatClass) {
        if (!overwrite) {
            throw new UnsupportedOperationException("Creating a file without overwriting is not currently supported in S3 Connector");
        }
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException("Path can not be empty!");
        }
        if (ParquetFormat.class.isAssignableFrom(formatClass)) {
            return new S3ParquetOutputStream(path, this.conf, this.s3);
        }
        return new S3OutputStream(path, this.conf, this.s3);
    }

    public OutputStream append(String filename) {
        throw new UnsupportedOperationException();
    }

    public void delete(String name) {
        if (this.bucketName.equals(name)) {
            return;
        }
        this.s3.deleteObject(this.bucketName, name);
    }

    public void close() {
    }

    public void addTags(String fileName, Map<String, String> tags) throws SdkClientException {
        ObjectTagging objectTagging = new ObjectTagging(tags.entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
        this.s3.setObjectTagging(new SetObjectTaggingRequest(this.bucketName, fileName, objectTagging));
    }

    public ObjectListing list(String path) {
        return this.s3.listObjects(this.bucketName, path);
    }

    public S3SinkConnectorConfig conf() {
        return this.conf;
    }

    public String url() {
        return this.url;
    }

    public SeekableInput open(String path, S3SinkConnectorConfig conf) {
        throw new UnsupportedOperationException("File reading is not currently supported in S3 Connector");
    }
}

