/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.util;

import com.amazonaws.Protocol;
import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.storage.common.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ProxyConfig {
    private static final Logger log = LoggerFactory.getLogger(S3ProxyConfig.class);
    private final Protocol protocol;
    private final String host;
    private final int port;
    private final String user;
    private final String pass;

    public S3ProxyConfig(S3SinkConnectorConfig config) {
        try {
            URL url = new URL(config.getString("s3.proxy.url"));
            this.protocol = S3ProxyConfig.extractProtocol(url.getProtocol());
            this.host = url.getHost();
            this.port = url.getPort();
            String username = config.getString("s3.proxy.user");
            this.user = StringUtils.isNotBlank((String)username) ? username : S3ProxyConfig.extractUser(url.getUserInfo());
            Password password = config.getPassword("s3.proxy.password");
            this.pass = StringUtils.isNotBlank((String)password.value()) ? password.value() : S3ProxyConfig.extractPass(url.getUserInfo());
            log.debug("Using proxy config {}", (Object)this);
        }
        catch (MalformedURLException e) {
            throw new ConfigException("s3.proxy.url", (Object)config.getString("s3.proxy.url"), e.toString());
        }
    }

    public static Protocol extractProtocol(String protocol) {
        if (StringUtils.isBlank((String)protocol)) {
            return Protocol.HTTPS;
        }
        return "http".equals(protocol.trim().toLowerCase(Locale.ROOT)) ? Protocol.HTTP : Protocol.HTTPS;
    }

    public static String extractUser(String userInfo) {
        return StringUtils.isBlank((String)userInfo) ? null : userInfo.split(":")[0];
    }

    public static String extractPass(String userInfo) {
        if (StringUtils.isBlank((String)userInfo)) {
            return null;
        }
        String[] parts = userInfo.split(":", 2);
        return parts.length == 2 ? parts[1] : null;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String user() {
        return this.user;
    }

    public String pass() {
        return this.pass;
    }

    public String toString() {
        return "S3ProxyConfig{protocol=" + this.protocol + ", host='" + this.host + '\'' + ", port=" + this.port + ", user='*****************', pass='*****************'" + '}';
    }
}

