/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import io.confluent.connect.storage.common.util.StringUtils;
import java.util.Map;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class AwsAssumeRoleCredentialsProvider
implements AWSCredentialsProvider,
Configurable {
    public static final String ROLE_EXTERNAL_ID_CONFIG = "sts.role.external.id";
    public static final String ROLE_ARN_CONFIG = "sts.role.arn";
    public static final String ROLE_SESSION_NAME_CONFIG = "sts.role.session.name";
    private static final ConfigDef STS_CONFIG_DEF = new ConfigDef().define("sts.role.external.id", ConfigDef.Type.STRING, ConfigDef.Importance.MEDIUM, "The role external ID used when retrieving session credentials under an assumed role.").define("sts.role.arn", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Role ARN to use when starting a session.").define("sts.role.session.name", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Role session name to use when starting a session");
    private String roleArn;
    private String roleExternalId;
    private String roleSessionName;
    private BasicAWSCredentials basicCredentials;
    private STSAssumeRoleSessionCredentialsProvider stsCredentialProvider;

    public void configure(Map<String, ?> configs) {
        AbstractConfig config = new AbstractConfig(STS_CONFIG_DEF, configs);
        this.roleArn = config.getString(ROLE_ARN_CONFIG);
        this.roleExternalId = config.getString(ROLE_EXTERNAL_ID_CONFIG);
        this.roleSessionName = config.getString(ROLE_SESSION_NAME_CONFIG);
        String accessKeyId = (String)configs.get("aws.access.key.id");
        String secretKey = (String)configs.get("aws.secret.access.key");
        if (StringUtils.isNotBlank((String)accessKeyId) && StringUtils.isNotBlank((String)secretKey)) {
            this.basicCredentials = new BasicAWSCredentials(accessKeyId, secretKey);
            this.stsCredentialProvider = new STSAssumeRoleSessionCredentialsProvider.Builder(this.roleArn, this.roleSessionName).withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)this.basicCredentials))).build()).withExternalId(this.roleExternalId).build();
        } else {
            this.basicCredentials = null;
            this.stsCredentialProvider = new STSAssumeRoleSessionCredentialsProvider.Builder(this.roleArn, this.roleSessionName).withStsClient(AWSSecurityTokenServiceClientBuilder.defaultClient()).withExternalId(this.roleExternalId).build();
        }
    }

    public AWSCredentials getCredentials() {
        return this.stsCredentialProvider.getCredentials();
    }

    public void refresh() {
        if (this.stsCredentialProvider != null) {
            this.stsCredentialProvider.refresh();
        }
    }
}

