/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format.parquet;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.format.RecordViewSetter;
import io.confluent.connect.s3.format.S3RetriableRecordWriter;
import io.confluent.connect.s3.format.parquet.ParquetFormat;
import io.confluent.connect.s3.storage.IORecordWriter;
import io.confluent.connect.s3.storage.S3ParquetOutputStream;
import io.confluent.connect.s3.storage.S3Storage;
import io.confluent.connect.s3.util.Utils;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordWriterProvider
extends RecordViewSetter
implements RecordWriterProvider<S3SinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(ParquetRecordWriterProvider.class);
    private static final String EXTENSION = ".parquet";
    private static final int PAGE_SIZE = 65536;
    private final S3Storage storage;
    private final AvroData avroData;

    ParquetRecordWriterProvider(S3Storage storage, AvroData avroData) {
        this.storage = storage;
        this.avroData = avroData;
    }

    public String getExtension() {
        return this.storage.conf().parquetCompressionCodecName().getExtension() + EXTENSION;
    }

    public RecordWriter getRecordWriter(S3SinkConnectorConfig conf, final String filename) {
        return new S3RetriableRecordWriter(new IORecordWriter(){
            final String adjustedFilename;
            org.apache.kafka.connect.data.Schema schema;
            ParquetWriter<GenericRecord> writer;
            S3ParquetOutputFile s3ParquetOutputFile;
            {
                this.adjustedFilename = Utils.getAdjustedFilename(ParquetRecordWriterProvider.this.recordView, filename, ParquetRecordWriterProvider.this.getExtension());
                this.schema = null;
            }

            @Override
            public void write(SinkRecord record) throws IOException {
                if (this.schema == null || this.writer == null) {
                    this.schema = ParquetRecordWriterProvider.this.recordView.getViewSchema(record, true);
                    log.info("Opening record writer for: {}", (Object)this.adjustedFilename);
                    Schema avroSchema = ParquetRecordWriterProvider.this.avroData.fromConnectSchema(this.schema);
                    this.s3ParquetOutputFile = new S3ParquetOutputFile(ParquetRecordWriterProvider.this.storage, this.adjustedFilename);
                    AvroParquetWriter.Builder builder = (AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)this.s3ParquetOutputFile).withSchema(avroSchema).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withDictionaryEncoding(true)).withCompressionCodec(ParquetRecordWriterProvider.this.storage.conf().parquetCompressionCodecName())).withPageSize(65536);
                    if (ParquetRecordWriterProvider.schemaHasArrayOfOptionalItems(this.schema, null)) {
                        log.debug("Setting \"parquet.avro.write-old-list-structure\" to false because the schema contains an array with optional items");
                        builder.config("parquet.avro.write-old-list-structure", "false");
                    }
                    this.writer = builder.build();
                }
                log.trace("Sink record with view {}: {}", (Object)ParquetRecordWriterProvider.this.recordView, (Object)Utils.sinkRecordToLoggableString(record));
                Object value = ParquetRecordWriterProvider.this.avroData.fromConnectData(this.schema, ParquetRecordWriterProvider.this.recordView.getView(record, true));
                this.writer.write((Object)((GenericRecord)value));
            }

            @Override
            public void close() throws IOException {
                if (this.writer != null) {
                    this.writer.close();
                }
            }

            @Override
            public void commit() throws IOException {
                this.s3ParquetOutputFile.s3out.setCommit();
                if (this.writer != null) {
                    this.writer.close();
                }
            }
        });
    }

    public static boolean schemaHasArrayOfOptionalItems(org.apache.kafka.connect.data.Schema schema, Set<org.apache.kafka.connect.data.Schema> seenSchemas) {
        if (seenSchemas == null) {
            seenSchemas = new HashSet<org.apache.kafka.connect.data.Schema>();
        } else if (seenSchemas.contains(schema)) {
            return false;
        }
        seenSchemas.add(schema);
        switch (schema.type()) {
            case STRUCT: {
                for (Field field : schema.fields()) {
                    if (!ParquetRecordWriterProvider.schemaHasArrayOfOptionalItems(field.schema(), seenSchemas)) continue;
                    return true;
                }
                return false;
            }
            case MAP: {
                return ParquetRecordWriterProvider.schemaHasArrayOfOptionalItems(schema.valueSchema(), seenSchemas);
            }
            case ARRAY: {
                return schema.valueSchema().isOptional() || ParquetRecordWriterProvider.schemaHasArrayOfOptionalItems(schema.valueSchema(), seenSchemas);
            }
        }
        return false;
    }

    private static class S3ParquetOutputFile
    implements OutputFile {
        private static final int DEFAULT_BLOCK_SIZE = 0;
        private S3Storage storage;
        private String filename;
        private S3ParquetOutputStream s3out;

        S3ParquetOutputFile(S3Storage storage, String filename) {
            this.storage = storage;
            this.filename = filename;
        }

        public PositionOutputStream create(long blockSizeHint) {
            this.s3out = (S3ParquetOutputStream)this.storage.create(this.filename, true, ParquetFormat.class);
            return this.s3out;
        }

        public PositionOutputStream createOrOverwrite(long blockSizeHint) {
            return this.create(blockSizeHint);
        }

        public boolean supportsBlockSize() {
            return false;
        }

        public long defaultBlockSize() {
            return 0L;
        }
    }
}

