/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.util;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger log = LoggerFactory.getLogger(RetryUtil.class);

    public static void exponentialBackoffRetry(Runnable runnable, Class<? extends Exception> exceptionClass, int totalNumIterations, long delayInMillis) throws ConnectException {
        long expDelayInMillis = delayInMillis;
        for (int i = 1; i <= totalNumIterations; ++i) {
            try {
                runnable.run();
                break;
            }
            catch (Exception e) {
                if (e.getClass().equals(exceptionClass)) {
                    log.warn("Attempt {} of {} failed.", new Object[]{i, totalNumIterations, e});
                    if (i == totalNumIterations) {
                        RetryUtil.wrapAndThrowAsConnectException(e);
                        continue;
                    }
                    log.warn("Awaiting {} milliseconds before retrying.", (Object)expDelayInMillis);
                    RetryUtil.await(expDelayInMillis);
                    expDelayInMillis <<= 1;
                    continue;
                }
                RetryUtil.wrapAndThrowAsConnectException(e);
                continue;
            }
        }
    }

    private static void wrapAndThrowAsConnectException(Exception e) throws ConnectException {
        if (e instanceof ConnectException) {
            throw (ConnectException)((Object)e);
        }
        throw new ConnectException((Throwable)e);
    }

    private static void await(long millis) {
        try {
            TimeUnit.MILLISECONDS.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

