/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.util;

import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.storage.partitioner.Partitioner;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;

public class SchemaPartitioner<T>
implements Partitioner<T> {
    private final Partitioner<T> delegatePartitioner;
    private S3SinkConnectorConfig.AffixType schemaAffixType;
    private String delim;

    public SchemaPartitioner(Partitioner<T> delegatePartitioner) {
        this.delegatePartitioner = delegatePartitioner;
    }

    public void configure(Map<String, Object> config) {
        this.delim = (String)config.get("directory.delim");
        this.schemaAffixType = S3SinkConnectorConfig.AffixType.valueOf((String)config.get("s3.schema.partition.affix.type"));
        this.delegatePartitioner.configure(config);
    }

    public String encodePartition(SinkRecord sinkRecord) {
        String encodePartition = this.delegatePartitioner.encodePartition(sinkRecord);
        Schema valueSchema = sinkRecord.valueSchema();
        String valueSchemaName = valueSchema != null ? valueSchema.name() : null;
        return this.generateSchemaBasedPath(encodePartition, valueSchemaName);
    }

    public String encodePartition(SinkRecord sinkRecord, long nowInMillis) {
        String encodePartition = this.delegatePartitioner.encodePartition(sinkRecord, nowInMillis);
        Schema valueSchema = sinkRecord.valueSchema();
        String valueSchemaName = valueSchema != null ? valueSchema.name() : null;
        return this.generateSchemaBasedPath(encodePartition, valueSchemaName);
    }

    private String generateSchemaBasedPath(String encodedPartition, String schemaName) {
        if (this.schemaAffixType == S3SinkConnectorConfig.AffixType.PREFIX) {
            return "schema_name=" + schemaName + this.delim + encodedPartition;
        }
        return encodedPartition + this.delim + "schema_name=" + schemaName;
    }

    public String generatePartitionedPath(String topic, String encodedPartition) {
        return this.delegatePartitioner.generatePartitionedPath(topic, encodedPartition);
    }

    public List<T> partitionFields() {
        return this.delegatePartitioner.partitionFields();
    }
}

