/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.KafkaMessageQueue;
import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMSConsumerRebalanceListener
implements ConsumerRebalanceListener {
    private static final Logger log = LoggerFactory.getLogger(JMSConsumerRebalanceListener.class);
    final KafkaMessageQueue messageQueue;

    JMSConsumerRebalanceListener(KafkaMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void onPartitionsRevoked(Collection<TopicPartition> collection) {
        log.trace("onPartitionsRevoked() - partitions: {}", (Object)Arrays.toString(collection.toArray()));
        this.messageQueue.clear();
    }

    public void onPartitionsAssigned(Collection<TopicPartition> collection) {
        log.trace("onPartitionsAssigned() - partitions: {}", (Object)Arrays.toString(collection.toArray()));
    }
}

