/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.confluent.kafka.jms.JsonHeaderValue;
import io.confluent.kafka.jms.JsonHeaderValueType;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHeader
implements Header {
    private static final Logger log = LoggerFactory.getLogger(JsonHeader.class);
    String key;
    JsonHeaderValue value;

    private JsonHeader(String key, JsonHeaderValueType type, Object value) {
        this.key = key;
        this.value = new JsonHeaderValue(type, value);
    }

    public JsonHeader(String key, Object value) {
        Preconditions.checkNotNull((Object)key, (Object)"key must not be null.");
        this.key = key;
        this.value = new JsonHeaderValue(value);
    }

    public JsonHeader(Header header) {
        this.key = header.key();
        this.value = new JsonHeaderValue(header.value());
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.value.asBytes();
    }

    public JsonHeaderValue getTypedValue() {
        return this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.value.type).add("value", this.value.value).toString();
    }
}

