/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.AccessMode;
import io.confluent.kafka.jms.KafkaJMSException;
import io.confluent.kafka.jms.KafkaMessage;
import io.confluent.kafka.jms.KafkaMessageQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.kafka.clients.consumer.ConsumerRecord;

class KafkaBytesMessage
extends KafkaMessage
implements BytesMessage {
    public static final String MESSAGE_TYPE = "bytes";
    ByteArrayOutputStream payloadWriteOnlyStream;
    byte[] payloadReadOnlyBytes;
    ByteArrayInputStream payloadReadOnlyStream;
    AccessMode accessMode;

    @Override
    protected String messageType() {
        return MESSAGE_TYPE;
    }

    @Override
    protected byte[] serializeBody() throws JMSException {
        if (this.payloadWriteOnlyStream != null) {
            return this.payloadWriteOnlyStream.toByteArray();
        }
        return this.payloadReadOnlyBytes;
    }

    @Override
    public void clearBody() throws JMSException {
        this.payloadWriteOnlyStream = new ByteArrayOutputStream();
        this.payloadReadOnlyStream = null;
        this.payloadReadOnlyBytes = null;
        this.accessMode = AccessMode.WriteOnly;
    }

    public KafkaBytesMessage(KafkaMessageQueue messageQueue, ConsumerRecord<byte[], byte[]> record, boolean allowOutOfOrderAcknowledge) throws JMSException {
        super(messageQueue, record, allowOutOfOrderAcknowledge);
        this.payloadReadOnlyBytes = (byte[])record.value();
        if (this.payloadReadOnlyBytes == null) {
            throw new JMSException("KafkaBytesMessage payload may not be null.");
        }
        this.payloadReadOnlyStream = new ByteArrayInputStream(this.payloadReadOnlyBytes);
        this.payloadWriteOnlyStream = null;
        this.accessMode = AccessMode.ReadOnly;
    }

    public KafkaBytesMessage() {
        this.accessMode = AccessMode.WriteOnly;
        this.payloadReadOnlyBytes = null;
        this.payloadReadOnlyStream = null;
        this.payloadWriteOnlyStream = new ByteArrayOutputStream();
    }

    public long getBodyLength() throws JMSException {
        if (this.accessMode != AccessMode.ReadOnly) {
            throw new MessageNotReadableException("Attempt to read length of a message that is not in ReadOnly mode.");
        }
        return this.payloadReadOnlyBytes.length;
    }

    void doWrite(Writer writer) throws JMSException {
        if (this.accessMode == AccessMode.ReadOnly) {
            throw new MessageNotWriteableException("Message not writable.");
        }
        try (DataOutputStream outputStream = new DataOutputStream(this.payloadWriteOnlyStream);){
            writer.write(outputStream);
        }
        catch (IOException ex) {
            throw new KafkaJMSException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T doRead(Reader<T> reader) throws JMSException {
        if (this.accessMode == AccessMode.WriteOnly) {
            throw new MessageNotReadableException("Message not readable.");
        }
        try (DataInputStream inputStream = new DataInputStream(this.payloadReadOnlyStream);){
            T t = reader.read(inputStream);
            return t;
        }
        catch (IOException ex) {
            throw new KafkaJMSException(ex);
        }
    }

    public boolean readBoolean() throws JMSException {
        return this.doRead(new Reader<Boolean>(){

            @Override
            public Boolean read(DataInputStream inputStream) throws IOException {
                return inputStream.readBoolean();
            }
        });
    }

    public byte readByte() throws JMSException {
        return this.doRead(new Reader<Byte>(){

            @Override
            public Byte read(DataInputStream inputStream) throws IOException {
                return inputStream.readByte();
            }
        });
    }

    public int readUnsignedByte() throws JMSException {
        return this.doRead(new Reader<Integer>(){

            @Override
            public Integer read(DataInputStream inputStream) throws IOException {
                return inputStream.readUnsignedByte();
            }
        });
    }

    public short readShort() throws JMSException {
        return this.doRead(new Reader<Short>(){

            @Override
            public Short read(DataInputStream inputStream) throws IOException {
                return inputStream.readShort();
            }
        });
    }

    public int readUnsignedShort() throws JMSException {
        return this.doRead(new Reader<Integer>(){

            @Override
            public Integer read(DataInputStream inputStream) throws IOException {
                return inputStream.readUnsignedShort();
            }
        });
    }

    public char readChar() throws JMSException {
        return this.doRead(new Reader<Character>(){

            @Override
            public Character read(DataInputStream inputStream) throws IOException {
                return Character.valueOf(inputStream.readChar());
            }
        }).charValue();
    }

    public int readInt() throws JMSException {
        return this.doRead(new Reader<Integer>(){

            @Override
            public Integer read(DataInputStream inputStream) throws IOException {
                return inputStream.readInt();
            }
        });
    }

    public long readLong() throws JMSException {
        return this.doRead(new Reader<Long>(){

            @Override
            public Long read(DataInputStream inputStream) throws IOException {
                return inputStream.readLong();
            }
        });
    }

    public float readFloat() throws JMSException {
        return this.doRead(new Reader<Float>(){

            @Override
            public Float read(DataInputStream inputStream) throws IOException {
                return Float.valueOf(inputStream.readFloat());
            }
        }).floatValue();
    }

    public double readDouble() throws JMSException {
        return this.doRead(new Reader<Double>(){

            @Override
            public Double read(DataInputStream inputStream) throws IOException {
                return inputStream.readDouble();
            }
        });
    }

    public String readUTF() throws JMSException {
        return this.doRead(new Reader<String>(){

            @Override
            public String read(DataInputStream inputStream) throws IOException {
                return inputStream.readUTF();
            }
        });
    }

    public int readBytes(byte[] bytes) throws JMSException {
        return this.readBytes(bytes, bytes.length);
    }

    public int readBytes(final byte[] bytes, final int length) throws JMSException {
        return this.doRead(new Reader<Integer>(){

            @Override
            public Integer read(DataInputStream inputStream) throws IOException {
                return inputStream.read(bytes, 0, length);
            }
        });
    }

    public void writeBoolean(final boolean value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeBoolean(value);
            }
        });
    }

    public void writeByte(final byte value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeByte(value);
            }
        });
    }

    public void writeShort(final short value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeShort(value);
            }
        });
    }

    public void writeChar(final char value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeChar(value);
            }
        });
    }

    public void writeInt(final int value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeInt(value);
            }
        });
    }

    public void writeLong(final long value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeLong(value);
            }
        });
    }

    public void writeFloat(final float value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeFloat(value);
            }
        });
    }

    public void writeDouble(final double value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeDouble(value);
            }
        });
    }

    public void writeUTF(final String value) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.writeUTF(value);
            }
        });
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(final byte[] bytes, final int offset, final int length) throws JMSException {
        this.doWrite(new Writer(){

            @Override
            public void write(DataOutputStream outputStream) throws IOException {
                outputStream.write(bytes, offset, length);
            }
        });
    }

    public void writeObject(Object value) throws JMSException {
        if (null == value) {
            throw new NullPointerException("value cannot be null.");
        }
        throw new JMSException("writeObject() is not supported by this client.");
    }

    public void reset() throws JMSException {
        this.accessMode = AccessMode.ReadOnly;
    }

    static interface Writer {
        public void write(DataOutputStream var1) throws IOException;
    }

    static interface Reader<T> {
        public T read(DataInputStream var1) throws IOException;
    }
}

