/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.JNDIPreconditions;
import io.confluent.kafka.jms.KafkaNamingEnumeration;
import io.confluent.kafka.jms.NameParserImpl;
import io.confluent.kafka.jms.Unsupported;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaContext
implements Context {
    private static final Logger log = LoggerFactory.getLogger(KafkaContext.class);
    final Hashtable<Name, Binding> bindings;
    final Hashtable<String, Object> environment;
    final String nameInNamespace = "";
    protected static final NameParser NAME_PARSER = new NameParserImpl();

    KafkaContext(Hashtable environment) {
        this.environment = null == environment ? new Hashtable() : new Hashtable(environment);
        this.bindings = new Hashtable();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object result;
        log.trace("lookup(Name '{}')", (Object)name);
        JNDIPreconditions.checkName(name);
        if (name.isEmpty()) {
            return this;
        }
        Binding binding = this.bindings.get(name);
        if (null == binding) {
            log.trace("Nothing was found for {}", (Object)name);
            result = null;
        } else if (binding.getObject() instanceof LinkRef) {
            LinkRef linkRef = (LinkRef)binding.getObject();
            Name linkRefName = NAME_PARSER.parse(linkRef.getLinkName());
            log.trace("Found '{}' is link for {}.", (Object)name, (Object)linkRefName);
            Binding linkedBinding = this.bindings.get(linkRefName);
            result = linkedBinding.getObject();
        } else {
            result = binding.getObject();
        }
        return result;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        log.trace("lookup(String '{}')", (Object)name);
        Name parsed = NAME_PARSER.parse(name);
        return this.lookup(parsed);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        log.trace("bind({}, {})", (Object)name, obj);
        JNDIPreconditions.checkName(name);
        if (this.bindings.containsKey(name)) {
            throw new NameAlreadyBoundException(String.format("name(%s) is already bound", name));
        }
        Binding binding = new Binding(name.toString(), obj);
        this.bindings.put(name, binding);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        Name n = NAME_PARSER.parse(name);
        this.bind(n, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.unbind(name);
        this.bind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        Name n = NAME_PARSER.parse(name);
        this.rebind(n, obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        log.trace("unbind({})", (Object)name);
        JNDIPreconditions.checkNotEmpty(name);
        if (!this.bindings.containsKey(name)) {
            throw new NameNotFoundException(String.format("Name '%s' was not found.", name));
        }
        this.bindings.remove(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        Name n = NAME_PARSER.parse(name);
        this.unbind(n);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        JNDIPreconditions.checkName(oldName, "oldName");
        JNDIPreconditions.checkName(newName, "newName");
        if (null != this.lookup(newName)) {
            throw new NameAlreadyBoundException(String.format("newName '%s' is already bound.", newName));
        }
        Object value = this.lookup(oldName);
        if (null == value) {
            throw new NameNotFoundException(String.format("oldName '%s' was not found.", oldName));
        }
        this.bind(newName, value);
        this.unbind(oldName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        JNDIPreconditions.checkName(oldName, "oldName");
        JNDIPreconditions.checkName(newName, "newName");
        Name o = NAME_PARSER.parse(oldName);
        Name n = NAME_PARSER.parse(newName);
        this.rename(o, n);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        JNDIPreconditions.checkName(name, "name", true);
        ArrayList<Binding> results = new ArrayList<Binding>();
        for (Map.Entry<Name, Binding> kvp : this.bindings.entrySet()) {
            if (!kvp.getKey().startsWith(name)) continue;
            results.add(kvp.getValue());
        }
        Enumeration enumeration = Collections.enumeration(results);
        return new KafkaNamingEnumeration<NameClassPair>(enumeration);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        Name n = NAME_PARSER.parse(name);
        return this.list(n);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        JNDIPreconditions.checkName(name, "name", true);
        ArrayList<Binding> results = new ArrayList<Binding>();
        for (Map.Entry<Name, Binding> kvp : this.bindings.entrySet()) {
            if (!kvp.getKey().startsWith(name)) continue;
            results.add(kvp.getValue());
        }
        Enumeration enumeration = Collections.enumeration(results);
        return new KafkaNamingEnumeration<Binding>(enumeration);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Name n = NAME_PARSER.parse(name);
        return this.listBindings(n);
    }

    @Override
    @Unsupported(value="not supported.")
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    @Unsupported(value="not supported.")
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    @Unsupported(value="not supported.")
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    @Unsupported(value="not supported.")
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return NAME_PARSER;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return NAME_PARSER;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        JNDIPreconditions.checkName(name);
        JNDIPreconditions.checkName(prefix, "prefix", true);
        Name result = (Name)prefix.clone();
        result = result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name n = NAME_PARSER.parse(name);
        Name p = NAME_PARSER.parse(prefix);
        Name result = this.composeName(n, p);
        return result.toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.nameInNamespace;
    }
}

