/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.confluent.kafka.jms.AccessMode;
import io.confluent.kafka.jms.JMSPreconditions;
import io.confluent.kafka.jms.JsonDestination;
import io.confluent.kafka.jms.JsonHeader;
import io.confluent.kafka.jms.KafkaDestination;
import io.confluent.kafka.jms.KafkaJMSException;
import io.confluent.kafka.jms.KafkaMessageQueue;
import io.confluent.kafka.jms.KafkaQueue;
import io.confluent.kafka.jms.KafkaTopic;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class KafkaMessage
implements Message {
    private static final Logger log = LoggerFactory.getLogger(KafkaMessage.class);
    static final String JMS_HEADER_PREFIX = "jms.";
    static final String JMS_PROPERTY_PREFIX = "jms.property.";
    static final String JMS_MESSAGE_TYPE = "jms.message.type";
    static final String JMS_DESTINATION = "jms.destination";
    static final String JMS_CORRELATION_ID = "jms.correlation.id";
    static final String JMS_DELIVERY_MODE = "jms.delivery.mode";
    static final String JMS_REDELIVERED = "jms.redelivered";
    static final String JMS_TYPE = "jms.type";
    static final String JMS_REPLYTO = "jms.replyto";
    static final String JMS_EXPIRATION = "jms.expiration";
    static final String JMS_PRIORITY = "jms.priority";
    static final String[] ALL_HEADERS = new String[]{"jms.correlation.id", "jms.delivery.mode", "jms.redelivered", "jms.type", "jms.replyto", "jms.expiration", "jms.priority", "jms.destination"};
    static final Map<String, Object> DEFAULT_HEADER_VALUES = new HashMap<String, Object>();
    protected final Map<String, Object> headers;
    protected final Map<String, Object> properties;
    protected final KafkaMessageQueue messageQueue;
    protected TopicPartition topicPartition;
    protected long offset;
    String jmsMessageID;
    long timestamp;
    boolean allowOutOfOrderAcknowledge;
    AccessMode propertiesAccessMode;
    static final Set<Class<? extends Serializable>> ALLOWED_TYPES;

    protected abstract String messageType();

    protected abstract byte[] serializeBody() throws JMSException;

    public abstract void clearBody() throws JMSException;

    public KafkaMessage(KafkaMessageQueue messageQueue, ConsumerRecord<byte[], byte[]> record, boolean allowOutOfOrderAcknowledge) {
        this.allowOutOfOrderAcknowledge = allowOutOfOrderAcknowledge;
        this.messageQueue = messageQueue;
        this.topicPartition = new TopicPartition(record.topic(), record.partition());
        this.headers = KafkaMessage.readHeaders(record.headers());
        this.properties = KafkaMessage.readProperties(record.headers());
        this.offset = record.offset();
        this.propertiesAccessMode = AccessMode.ReadOnly;
        this.timestamp = record.timestamp();
    }

    public KafkaMessage() {
        this.messageQueue = null;
        this.topicPartition = null;
        this.offset = -1L;
        this.headers = new LinkedHashMap<String, Object>(DEFAULT_HEADER_VALUES);
        this.properties = new LinkedHashMap<String, Object>();
        this.propertiesAccessMode = AccessMode.ReadWrite;
        this.timestamp = System.currentTimeMillis();
        this.allowOutOfOrderAcknowledge = true;
    }

    public String getJMSMessageID() throws JMSException {
        return this.jmsMessageID;
    }

    public void setJMSMessageID(String messageID) throws JMSException {
        if (null == messageID) {
            throw new JMSException("JMSMessageID cannot be null.");
        }
        try {
            String[] parts = messageID.split(":");
            Preconditions.checkState((parts.length == 4 ? 1 : 0) != 0, (String)"JMSMessageID '%s' is not formatted properly.", (Object[])new Object[]{messageID});
            Preconditions.checkState((boolean)"ID".equalsIgnoreCase(parts[0]), (Object)"JMSMessageID must start with ID:");
            String topic = parts[1];
            Preconditions.checkState((!Strings.isNullOrEmpty((String)topic) ? 1 : 0) != 0, (Object)"topic cannot be null or empty.");
            Integer partition = Ints.tryParse((String)parts[2]);
            Preconditions.checkNotNull((Object)partition, (String)"partition '%s' could not be parsed.", (Object[])new Object[]{parts[2]});
            Long offset = Longs.tryParse((String)parts[3]);
            Preconditions.checkNotNull((Object)offset, (String)"offset '%s' could not be parsed.", (Object[])new Object[]{parts[3]});
            TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
            this.setJMSMessageID(topicPartition, offset);
        }
        catch (Exception ex) {
            JMSException jmsException = new JMSException("Exception thrown while setting JMSMessageID");
            jmsException.initCause((Throwable)ex);
            jmsException.setLinkedException(ex);
            throw jmsException;
        }
    }

    void setJMSMessageID(TopicPartition topicPartition, long offset) {
        this.topicPartition = topicPartition;
        this.offset = offset;
        this.jmsMessageID = String.format("ID:%s:%d:%d", this.topicPartition.topic(), this.topicPartition.partition(), this.offset);
    }

    public long getJMSTimestamp() throws JMSException {
        return this.timestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.timestamp = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.getJMSCorrelationID().getBytes(Charsets.UTF_8);
    }

    public void setJMSCorrelationIDAsBytes(byte[] bytes) throws JMSException {
        throw new JMSException("setJMSCorrelationIDAsBytes() is not supported by this client.");
    }

    public String getJMSCorrelationID() throws JMSException {
        return (String)this.headers.get(JMS_CORRELATION_ID);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        if (Strings.isNullOrEmpty((String)correlationID)) {
            this.headers.remove(correlationID);
        } else {
            this.headers.put(JMS_CORRELATION_ID, correlationID);
        }
    }

    public Destination getJMSReplyTo() throws JMSException {
        if (!this.headers.containsKey(JMS_REPLYTO)) {
            return null;
        }
        JsonDestination headerValue = (JsonDestination)this.headers.get(JMS_REPLYTO);
        if (headerValue == null) {
            return null;
        }
        return Objects.equals(headerValue.type, "queue") ? new KafkaQueue(headerValue.name) : new KafkaTopic(headerValue.name);
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (null == destination) {
            this.headers.remove(JMS_REPLYTO);
        } else {
            KafkaDestination d = JMSPreconditions.checkDestination(destination);
            JsonDestination jsonDestination = new JsonDestination();
            jsonDestination.type = d instanceof KafkaQueue ? "queue" : "topic";
            jsonDestination.name = d.topic;
            this.headers.put(JMS_REPLYTO, jsonDestination);
        }
    }

    public Destination getJMSDestination() throws JMSException {
        if (!this.headers.containsKey(JMS_DESTINATION)) {
            return null;
        }
        JsonDestination headerValue = (JsonDestination)this.headers.get(JMS_DESTINATION);
        if (headerValue == null) {
            return null;
        }
        return Objects.equals(headerValue.type, "queue") ? new KafkaQueue(headerValue.name) : new KafkaTopic(headerValue.name);
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (null == destination) {
            this.headers.remove(JMS_DESTINATION);
        } else {
            KafkaDestination d = JMSPreconditions.checkDestination(destination);
            JsonDestination jsonDestination = new JsonDestination();
            jsonDestination.type = d instanceof KafkaQueue ? "queue" : "topic";
            jsonDestination.name = d.topic;
            this.headers.put(JMS_DESTINATION, jsonDestination);
        }
    }

    public int getJMSDeliveryMode() throws JMSException {
        return (Integer)this.headers.get(JMS_DELIVERY_MODE);
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.headers.put(JMS_DELIVERY_MODE, deliveryMode);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return (Boolean)this.headers.get(JMS_REDELIVERED);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.headers.put(JMS_REDELIVERED, redelivered);
    }

    public String getJMSType() throws JMSException {
        return (String)this.headers.get(JMS_TYPE);
    }

    public void setJMSType(String type) throws JMSException {
        this.headers.put(JMS_TYPE, type);
    }

    public long getJMSExpiration() throws JMSException {
        return (Long)this.headers.get(JMS_EXPIRATION);
    }

    public void setJMSExpiration(long l) throws JMSException {
        this.headers.put(JMS_EXPIRATION, l);
    }

    public int getJMSPriority() throws JMSException {
        return (Integer)this.headers.get(JMS_PRIORITY);
    }

    public void setJMSPriority(int expiration) throws JMSException {
        this.headers.put(JMS_PRIORITY, expiration);
    }

    public void clearProperties() throws JMSException {
        this.properties.clear();
        this.propertiesAccessMode = AccessMode.ReadWrite;
    }

    public boolean propertyExists(String propertyName) throws JMSException {
        return this.properties.containsKey(propertyName);
    }

    <T> T getPropertyInternal(String propertyName, Class<T> cls) throws JMSException {
        log.trace("getPropertyInternal() - propertyName = '{}'", (Object)propertyName);
        Object value = this.properties.get(propertyName);
        try {
            if (value == null && cls == String.class) {
                return null;
            }
            if (cls == value.getClass()) {
                return (T)value;
            }
            if (cls == String.class) {
                return (T)value.toString();
            }
            if (cls == Boolean.class) {
                if (value.getClass() == String.class) {
                    return (T)Boolean.valueOf((String)value);
                }
            } else if (cls == Byte.class) {
                if (value.getClass() == String.class) {
                    return (T)Byte.valueOf((String)value);
                }
            } else if (cls == Short.class) {
                if (value.getClass() == String.class) {
                    return (T)Short.valueOf((String)value);
                }
                if (value.getClass() == Byte.class) {
                    return (T)Short.valueOf(((Byte)value).shortValue());
                }
            } else if (cls == Integer.class) {
                if (value.getClass() == String.class) {
                    return (T)Integer.valueOf((String)value);
                }
                if (value.getClass() == Byte.class) {
                    return (T)Integer.valueOf(((Byte)value).intValue());
                }
                if (value.getClass() == Short.class) {
                    return (T)Integer.valueOf(((Short)value).intValue());
                }
            } else if (cls == Long.class) {
                if (value.getClass() == String.class) {
                    return (T)Long.valueOf((String)value);
                }
                if (value.getClass() == Byte.class) {
                    return (T)Long.valueOf(((Byte)value).longValue());
                }
                if (value.getClass() == Short.class) {
                    return (T)Long.valueOf(((Short)value).longValue());
                }
                if (value.getClass() == Integer.class) {
                    return (T)Long.valueOf(((Integer)value).longValue());
                }
            } else if (cls == Float.class) {
                if (value.getClass() == String.class) {
                    return (T)Float.valueOf((String)value);
                }
            } else if (cls == Double.class) {
                if (value.getClass() == String.class) {
                    return (T)Float.valueOf((String)value);
                }
                if (value.getClass() == Float.class) {
                    return (T)Double.valueOf(((Float)value).doubleValue());
                }
            }
        }
        catch (Exception ex) {
            throw new MessageFormatException("Invalid cast.", ex.getMessage());
        }
        throw new MessageFormatException(String.format("Invalid JMS type conversion %s -> %s", value.getClass().getName(), cls.getName()));
    }

    public boolean getBooleanProperty(String propertyName) throws JMSException {
        return this.getPropertyInternal(propertyName, Boolean.class);
    }

    public byte getByteProperty(String propertyName) throws JMSException {
        return this.getPropertyInternal(propertyName, Byte.class);
    }

    public short getShortProperty(String propertyName) throws JMSException {
        return this.getPropertyInternal(propertyName, Short.class);
    }

    public int getIntProperty(String propertyName) throws JMSException {
        return this.getPropertyInternal(propertyName, Integer.class);
    }

    public long getLongProperty(String propertyName) throws JMSException {
        return this.getPropertyInternal(propertyName, Long.class);
    }

    public float getFloatProperty(String propertyName) throws JMSException {
        return this.getPropertyInternal(propertyName, Float.class).floatValue();
    }

    public double getDoubleProperty(String propertyName) throws JMSException {
        return this.getPropertyInternal(propertyName, Double.class);
    }

    public String getStringProperty(String propertyName) throws JMSException {
        return this.getPropertyInternal(propertyName, String.class);
    }

    public Object getObjectProperty(String propertyName) throws JMSException {
        return this.properties.get(propertyName);
    }

    public Enumeration getPropertyNames() throws JMSException {
        Vector<String> result = new Vector<String>(this.properties.keySet());
        return result.elements();
    }

    public void setBooleanProperty(String propertyName, boolean value) throws JMSException {
        this.setObjectProperty(propertyName, value);
    }

    public void setByteProperty(String propertyName, byte value) throws JMSException {
        this.setObjectProperty(propertyName, value);
    }

    public void setShortProperty(String propertyName, short value) throws JMSException {
        this.setObjectProperty(propertyName, value);
    }

    public void setIntProperty(String propertyName, int value) throws JMSException {
        this.setObjectProperty(propertyName, value);
    }

    public void setLongProperty(String propertyName, long value) throws JMSException {
        this.setObjectProperty(propertyName, value);
    }

    public void setFloatProperty(String propertyName, float value) throws JMSException {
        this.setObjectProperty(propertyName, Float.valueOf(value));
    }

    public void setDoubleProperty(String propertyName, double value) throws JMSException {
        this.setObjectProperty(propertyName, value);
    }

    public void setStringProperty(String propertyName, String value) throws JMSException {
        this.setObjectProperty(propertyName, value);
    }

    public void setObjectProperty(String propertyName, Object value) throws JMSException {
        log.trace("setObjectProperty() - propertyName = '{}', value = '{}'", (Object)propertyName, value);
        if (Strings.isNullOrEmpty((String)propertyName)) {
            throw new IllegalArgumentException("propertyName cannot be null or an empty string.");
        }
        if (this.propertiesAccessMode == AccessMode.ReadOnly) {
            throw new MessageNotWriteableException("Properties are read only.");
        }
        if (null != value && !ALLOWED_TYPES.contains(value.getClass())) {
            throw new MessageFormatException(String.format("Cannot set value for property '%s'. %s it not a supported JMS property type.", propertyName, value.getClass().getSimpleName()));
        }
        this.properties.put(propertyName, value);
    }

    public void acknowledge() throws JMSException {
        Long committedOffset;
        log.trace("acknowledge() - Committing offset for message. topic='{}' partition='{}' offset='{}'", new Object[]{this.topicPartition.topic(), this.topicPartition.partition(), this.offset});
        long offsetToCommit = this.offset + 1L;
        if (!this.allowOutOfOrderAcknowledge && (committedOffset = this.messageQueue.committed(this.topicPartition)) != null && offsetToCommit - committedOffset != 1L) {
            throw new JMSException(String.format("Message acknowledged out of order: topic='%s' partition='%d' message offset='%d' previous message offset='%d'", this.topicPartition.topic(), this.topicPartition.partition(), offsetToCommit - 1L, committedOffset - 1L));
        }
        try {
            this.messageQueue.commitSync(this.topicPartition, offsetToCommit);
        }
        catch (KafkaException ex) {
            throw new KafkaJMSException((Exception)((Object)ex));
        }
    }

    protected MoreObjects.ToStringHelper toStringHelper() throws JMSException {
        return MoreObjects.toStringHelper((Object)this).add("JMSCorrelationID", (Object)this.getJMSCorrelationID()).add("JMSDeliveryMode", this.getJMSDeliveryMode()).add("JMSDestination", (Object)this.getJMSDestination()).add("JMSExpiration", this.getJMSExpiration()).add("JMSMessageID", (Object)this.jmsMessageID).add("JMSPriority", this.getJMSPriority()).add("JMSRedelivered", this.getJMSRedelivered()).add("JMSReplyTo", (Object)this.getJMSReplyTo()).add("JMSTimestamp", this.getJMSTimestamp()).add("JMSType", (Object)this.getJMSType()).add("Type", (Object)this.getClass().getSimpleName());
    }

    public ProducerRecord build() throws JMSException {
        KafkaDestination destination = JMSPreconditions.checkDestination(this.getJMSDestination());
        RecordHeaders recordHeaders = new RecordHeaders();
        JsonHeader header = new JsonHeader(JMS_MESSAGE_TYPE, this.messageType());
        recordHeaders.add((Header)header);
        KafkaMessage.appendProperties((Headers)recordHeaders, this.properties);
        KafkaMessage.appendHeaders((Headers)recordHeaders, this.headers);
        return new ProducerRecord(destination.topic, null, Long.valueOf(this.timestamp), null, (Object)this.serializeBody(), (Iterable)recordHeaders);
    }

    static void appendProperties(Headers kafkaHeaders, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            kafkaHeaders.add((Header)new JsonHeader(String.format("%s%s", JMS_PROPERTY_PREFIX, entry.getKey()), entry.getValue()));
        }
    }

    static void appendHeaders(Headers kafkaHeaders, Map<String, Object> jmsHeaders) {
        for (Map.Entry<String, Object> entry : jmsHeaders.entrySet()) {
            kafkaHeaders.add((Header)new JsonHeader(entry.getKey(), entry.getValue()));
        }
    }

    static void addHeader(Map<String, Object> result, Headers headers, String key) {
        Object value;
        log.trace("addHeader() - key = '{}'", (Object)key);
        Header header = headers.lastHeader(key);
        if (null != header) {
            JsonHeader jsonHeader = new JsonHeader(header);
            value = jsonHeader.getTypedValue().value;
        } else {
            value = null;
            if (DEFAULT_HEADER_VALUES.containsKey(key)) {
                value = DEFAULT_HEADER_VALUES.get(key);
            }
        }
        log.trace("addHeader() - key = '{}' value = '{}'", (Object)key, value);
        result.put(key, value);
    }

    static Map<String, Object> readHeaders(Headers headers) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String header : ALL_HEADERS) {
            KafkaMessage.addHeader(result, headers, header);
        }
        return result;
    }

    static Map<String, Object> readProperties(Headers headers) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Header header : headers) {
            if (!header.key().startsWith(JMS_PROPERTY_PREFIX)) continue;
            log.trace("readProperties() - processing header '{}'", (Object)header.key());
            String propertyName = header.key().substring(JMS_PROPERTY_PREFIX.length());
            JsonHeader jsonHeader = new JsonHeader(header);
            properties.put(propertyName, jsonHeader.getTypedValue().value);
        }
        return properties;
    }

    public String toString() {
        try {
            return this.toStringHelper().toString();
        }
        catch (JMSException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        DEFAULT_HEADER_VALUES.put(JMS_DELIVERY_MODE, 2);
        DEFAULT_HEADER_VALUES.put(JMS_REDELIVERED, false);
        DEFAULT_HEADER_VALUES.put(JMS_EXPIRATION, 0L);
        DEFAULT_HEADER_VALUES.put(JMS_PRIORITY, 4);
        ALLOWED_TYPES = ImmutableSet.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, (Object[])new Class[]{String.class, byte[].class, Boolean.class, Character.class});
    }
}

