/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.AccessMode;
import io.confluent.kafka.jms.JMSIOException;
import io.confluent.kafka.jms.KafkaMessage;
import io.confluent.kafka.jms.KafkaMessageQueue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import org.apache.kafka.clients.consumer.ConsumerRecord;

class KafkaObjectMessage
extends KafkaMessage
implements ObjectMessage {
    public static final String MESSAGE_TYPE = "object";
    byte[] serialized;
    AccessMode accessMode;

    @Override
    protected String messageType() {
        return MESSAGE_TYPE;
    }

    @Override
    protected byte[] serializeBody() throws JMSException {
        return this.serialized;
    }

    @Override
    public void clearBody() throws JMSException {
        this.serialized = null;
        this.accessMode = AccessMode.ReadWrite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] serializeBody(Serializable object) throws JMSIOException {
        if (object == null) {
            return null;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);){
                outputStream.writeObject(object);
                outputStream.flush();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new JMSIOException("Exception thrown while writing object.", e);
        }
    }

    /*
     * Exception decompiling
     */
    private static Serializable deserializeBody(byte[] body) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public KafkaObjectMessage(KafkaMessageQueue messageQueue, ConsumerRecord<byte[], byte[]> record, boolean allowOutOfOrderAcknowledge) throws JMSException {
        super(messageQueue, record, allowOutOfOrderAcknowledge);
        this.serialized = (byte[])record.value();
        this.accessMode = AccessMode.ReadOnly;
    }

    public KafkaObjectMessage() {
        this.accessMode = AccessMode.ReadWrite;
    }

    public Serializable getObject() throws JMSException {
        if (this.serialized == null) {
            return null;
        }
        return KafkaObjectMessage.deserializeBody(this.serialized);
    }

    public void setObject(Serializable serializable) throws JMSException {
        if (this.accessMode == AccessMode.ReadOnly) {
            throw new MessageNotWriteableException("Message not writable.");
        }
        this.serialized = KafkaObjectMessage.serializeBody(serializable);
    }
}

