/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.KafkaJMSException;
import io.confluent.kafka.jms.KafkaMessageQueue;
import io.confluent.kafka.jms.KafkaQueue;
import java.io.IOException;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

class KafkaQueueBrowser
implements QueueBrowser {
    final KafkaQueue kafkaQueue;
    final String messageSelector;
    final KafkaMessageQueue messageQueue;

    KafkaQueueBrowser(KafkaQueue kafkaQueue, String messageSelector, KafkaMessageQueue messageQueue) {
        this.kafkaQueue = kafkaQueue;
        this.messageSelector = messageSelector;
        this.messageQueue = messageQueue;
    }

    public Queue getQueue() throws JMSException {
        return this.kafkaQueue;
    }

    public String getMessageSelector() throws JMSException {
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        return new KafkaMessageQueue.Enumeration(this.messageQueue);
    }

    public void close() throws JMSException {
        try {
            this.messageQueue.close();
        }
        catch (IOException e) {
            throw new KafkaJMSException(e);
        }
    }
}

