/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.JNDIPreconditions;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NameParserImpl
implements NameParser {
    private static final Logger log = LoggerFactory.getLogger(NameParserImpl.class);
    static final Name QUEUE_NAME;
    static final Name TOPIC_NAME;

    NameParserImpl() {
    }

    @Override
    public Name parse(String name) throws NamingException {
        log.trace("parse('{}')", (Object)name);
        JNDIPreconditions.checkName(name, "name", true);
        String[] parts = name.split("\\.");
        Name result = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            result = QUEUE_NAME.get(0).equals(part) && i == 0 ? (Name)QUEUE_NAME.clone() : (TOPIC_NAME.get(0).equals(part) && i == 0 ? (Name)TOPIC_NAME.clone() : (null != result ? result.add(part) : new CompositeName(part)));
        }
        log.trace("parse('{}') - result {}", (Object)name, result);
        return result;
    }

    static {
        try {
            QUEUE_NAME = new CompositeName("queue");
            TOPIC_NAME = new CompositeName("topic");
        }
        catch (InvalidNameException e) {
            throw new IllegalStateException(e);
        }
    }
}

