/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;

public class ArraySchemaDiff {
    static void compare(Context ctx, ArraySchema original, ArraySchema update) {
        ArraySchemaDiff.compareItemSchemaObject(ctx, original, update);
        ArraySchemaDiff.compareItemSchemaArray(ctx, original, update);
        ArraySchemaDiff.compareAdditionalItems(ctx, original, update);
        ArraySchemaDiff.compareAttributes(ctx, original, update);
    }

    private static void compareAttributes(Context ctx, ArraySchema original, ArraySchema update) {
        if (!Objects.equals(original.getMaxItems(), update.getMaxItems())) {
            if (original.getMaxItems() == null && update.getMaxItems() != null) {
                ctx.addDifference("maxItems", Difference.Type.MAX_ITEMS_ADDED);
            } else if (original.getMaxItems() != null && update.getMaxItems() == null) {
                ctx.addDifference("maxItems", Difference.Type.MAX_ITEMS_REMOVED);
            } else if (original.getMaxItems() < update.getMaxItems()) {
                ctx.addDifference("maxItems", Difference.Type.MAX_ITEMS_INCREASED);
            } else if (original.getMaxItems() > update.getMaxItems()) {
                ctx.addDifference("maxItems", Difference.Type.MAX_ITEMS_DECREASED);
            }
        }
        if (!Objects.equals(original.getMinItems(), update.getMinItems())) {
            if (original.getMinItems() == null && update.getMinItems() != null) {
                ctx.addDifference("minItems", Difference.Type.MIN_ITEMS_ADDED);
            } else if (original.getMinItems() != null && update.getMinItems() == null) {
                ctx.addDifference("minItems", Difference.Type.MIN_ITEMS_REMOVED);
            } else if (original.getMinItems() < update.getMinItems()) {
                ctx.addDifference("minItems", Difference.Type.MIN_ITEMS_INCREASED);
            } else if (original.getMinItems() > update.getMinItems()) {
                ctx.addDifference("minItems", Difference.Type.MIN_ITEMS_DECREASED);
            }
        }
        if (original.needsUniqueItems() != update.needsUniqueItems()) {
            if (original.needsUniqueItems()) {
                ctx.addDifference("uniqueItems", Difference.Type.UNIQUE_ITEMS_REMOVED);
            } else {
                ctx.addDifference("uniqueItems", Difference.Type.UNIQUE_ITEMS_ADDED);
            }
        }
    }

    private static void compareAdditionalItems(Context ctx, ArraySchema original, ArraySchema update) {
        try (Context.PathScope pathScope = ctx.enterPath("additionalItems");){
            if (original.permitsAdditionalItems() != update.permitsAdditionalItems()) {
                if (original.permitsAdditionalItems()) {
                    ctx.addDifference(Difference.Type.ADDITIONAL_ITEMS_REMOVED);
                } else {
                    ctx.addDifference(Difference.Type.ADDITIONAL_ITEMS_ADDED);
                }
            } else if (original.getSchemaOfAdditionalItems() == null && update.getSchemaOfAdditionalItems() != null) {
                ctx.addDifference(Difference.Type.ADDITIONAL_ITEMS_NARROWED);
            } else if (update.getSchemaOfAdditionalItems() == null && original.getSchemaOfAdditionalItems() != null) {
                ctx.addDifference(Difference.Type.ADDITIONAL_ITEMS_EXTENDED);
            } else {
                SchemaDiff.compare(ctx, original.getSchemaOfAdditionalItems(), update.getSchemaOfAdditionalItems());
            }
        }
    }

    private static void compareItemSchemaArray(Context ctx, ArraySchema original, ArraySchema update) {
        int updateSize;
        int originalSize;
        List updateSchemas;
        List originalSchemas = original.getItemSchemas();
        if (originalSchemas == null) {
            originalSchemas = Collections.emptyList();
        }
        if ((updateSchemas = update.getItemSchemas()) == null) {
            updateSchemas = Collections.emptyList();
        }
        if ((originalSize = originalSchemas.size()) < (updateSize = updateSchemas.size())) {
            ctx.addDifference(original.permitsAdditionalItems() ? Difference.Type.ITEMS_ADDED_TO_OPEN_CONTENT_MODEL : Difference.Type.ITEMS_ADDED_TO_CLOSED_CONTENT_MODEL);
        } else if (originalSize > updateSize) {
            ctx.addDifference(original.permitsAdditionalItems() ? Difference.Type.ITEMS_REMOVED_FROM_OPEN_CONTENT_MODEL : Difference.Type.ITEMS_REMOVED_FROM_CLOSED_CONTENT_MODEL);
        }
        Iterator originalIterator = originalSchemas.iterator();
        Iterator updateIterator = updateSchemas.iterator();
        for (int index = 0; originalIterator.hasNext() && index < Math.min(originalSize, updateSize); ++index) {
            try (Context.PathScope pathScope = ctx.enterPath("items/" + index);){
                SchemaDiff.compare(ctx, (Schema)originalIterator.next(), (Schema)updateIterator.next());
                continue;
            }
        }
    }

    private static void compareItemSchemaObject(Context ctx, ArraySchema original, ArraySchema update) {
        try (Context.PathScope pathScope = ctx.enterPath("items");){
            SchemaDiff.compare(ctx, original.getAllItemSchema(), update.getAllItemSchema());
        }
    }
}

