/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import java.util.Iterator;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;

class CombinedSchemaDiff {
    CombinedSchemaDiff() {
    }

    static void compare(Context ctx, CombinedSchema original, CombinedSchema update) {
        if (!original.getCriterion().equals(update.getCriterion())) {
            ctx.addDifference(Difference.Type.COMPOSITION_METHOD_CHANGED);
        } else {
            int updateSize;
            int originalSize = original.getSubschemas().size();
            if (originalSize < (updateSize = update.getSubschemas().size())) {
                if (original.getCriterion() == CombinedSchema.ALL_CRITERION) {
                    ctx.addDifference(Difference.Type.PRODUCT_TYPE_EXTENDED);
                } else {
                    ctx.addDifference(Difference.Type.SUM_TYPE_EXTENDED);
                }
            } else if (originalSize > updateSize) {
                if (original.getCriterion() == CombinedSchema.ALL_CRITERION) {
                    ctx.addDifference(Difference.Type.PRODUCT_TYPE_NARROWED);
                } else {
                    ctx.addDifference(Difference.Type.SUM_TYPE_NARROWED);
                }
            }
            Iterator originalIterator = original.getSubschemas().iterator();
            Iterator updateIterator = update.getSubschemas().iterator();
            for (int index = 0; originalIterator.hasNext() && index < Math.min(originalSize, updateSize); ++index) {
                try (Context.PathScope pathScope = ctx.enterPath(original.getCriterion() + "/" + index);){
                    SchemaDiff.compare(ctx, (Schema)originalIterator.next(), (Schema)updateIterator.next());
                    continue;
                }
            }
        }
    }
}

