/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.confluent.kafka.schemaregistry.json.jackson.JsonOrgModule;

public class Jackson {
    private Jackson() {
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        return Jackson.configure(mapper);
    }

    public static ObjectMapper newObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        return Jackson.configure(mapper);
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        mapper.registerModule((Module)new GuavaModule());
        mapper.registerModule((Module)new JodaModule());
        mapper.registerModule((Module)new ParameterNamesModule());
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new JsonOrgModule());
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
        return mapper;
    }
}

