/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import io.confluent.kafka.schemaregistry.json.utils.Edge;
import io.confluent.kafka.schemaregistry.json.utils.MaximumCardinalityMatch;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;

class CombinedSchemaDiff {
    CombinedSchemaDiff() {
    }

    static void compare(Context ctx, CombinedSchema original, CombinedSchema update) {
        Difference.Type type = CombinedSchemaDiff.compareCriteria(ctx, original.getCriterion(), update.getCriterion());
        if (type != Difference.Type.COMBINED_TYPE_CHANGED) {
            int updateSize;
            LinkedHashSet originalSubschemas = new LinkedHashSet(original.getSubschemas());
            LinkedHashSet updateSubschemas = new LinkedHashSet(update.getSubschemas());
            int originalSize = originalSubschemas.size();
            if (originalSize < (updateSize = updateSubschemas.size())) {
                if (update.getCriterion() == CombinedSchema.ALL_CRITERION) {
                    ctx.addDifference(Difference.Type.PRODUCT_TYPE_EXTENDED);
                } else {
                    ctx.addDifference(Difference.Type.SUM_TYPE_EXTENDED);
                }
            } else if (originalSize > updateSize) {
                if (update.getCriterion() == CombinedSchema.ALL_CRITERION) {
                    ctx.addDifference(Difference.Type.PRODUCT_TYPE_NARROWED);
                } else {
                    ctx.addDifference(Difference.Type.SUM_TYPE_NARROWED);
                }
            }
            int index = 0;
            HashSet compatibleEdges = new HashSet();
            for (Schema originalSubschema : originalSubschemas) {
                try (Context.PathScope pathScope = ctx.enterPath(original.getCriterion() + "/" + index);){
                    for (Schema updateSubschema : updateSubschemas) {
                        Context subctx = ctx.getSubcontext();
                        SchemaDiff.compare(subctx, originalSubschema, updateSubschema);
                        if (!subctx.isCompatible()) continue;
                        compatibleEdges.add(new Edge<Schema, List<Difference>>(originalSubschema, updateSubschema, subctx.getDifferences()));
                    }
                }
                ++index;
            }
            MaximumCardinalityMatch match = new MaximumCardinalityMatch(compatibleEdges, originalSubschemas, updateSubschemas);
            Set matching = match.getMatching();
            for (Edge matchingEdge : matching) {
                ctx.addDifferences((List)matchingEdge.value());
            }
            if (matching.size() < Math.min(originalSize, updateSize)) {
                ctx.addDifference(Difference.Type.COMBINED_TYPE_SUBSCHEMAS_CHANGED);
            }
        }
    }

    private static Difference.Type compareCriteria(Context ctx, CombinedSchema.ValidationCriterion original, CombinedSchema.ValidationCriterion update) {
        Difference.Type type = original.equals(update) ? null : (update == CombinedSchema.ANY_CRITERION ? Difference.Type.COMBINED_TYPE_EXTENDED : Difference.Type.COMBINED_TYPE_CHANGED);
        if (type != null) {
            ctx.addDifference(type);
        }
        return type;
    }
}

