/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.confluent.kafka.schemaregistry.json.jackson.JsonOrgModule;

public class Jackson {
    private Jackson() {
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS}).build();
        return Jackson.configure(mapper);
    }

    public static ObjectMapper newObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper mapper = JsonMapper.builder((JsonFactory)jsonFactory).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS}).build();
        return Jackson.configure(mapper);
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        mapper.registerModule((Module)new GuavaModule());
        mapper.registerModule((Module)new JodaModule());
        mapper.registerModule((Module)new ParameterNamesModule());
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new JsonOrgModule());
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
        mapper.setSerializerProvider((DefaultSerializerProvider)new DefaultSerializerProviderImpl());
        return mapper;
    }

    static class UnknownSerializerImpl
    extends UnknownSerializer {
        public UnknownSerializerImpl() {
        }

        public UnknownSerializerImpl(Class<?> cls) {
            super(cls);
        }

        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            visitor.expectAnyFormat(typeHint);
        }
    }

    static class DefaultSerializerProviderImpl
    extends DefaultSerializerProvider {
        private static final long serialVersionUID = 1L;
        protected static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializerImpl();

        public DefaultSerializerProviderImpl() {
            this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        }

        public DefaultSerializerProviderImpl(DefaultSerializerProviderImpl src) {
            super((DefaultSerializerProvider)src);
            this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        }

        protected DefaultSerializerProviderImpl(SerializerProvider src, SerializationConfig config, SerializerFactory f) {
            super(src, config, f);
            this._unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
        }

        public DefaultSerializerProvider copy() {
            return ((Object)((Object)this)).getClass() != DefaultSerializerProviderImpl.class ? super.copy() : new DefaultSerializerProviderImpl(this);
        }

        public DefaultSerializerProviderImpl createInstance(SerializationConfig config, SerializerFactory jsf) {
            return new DefaultSerializerProviderImpl((SerializerProvider)this, config, jsf);
        }
    }
}

