/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.everit.json.schema.ValidationException;

public abstract class AbstractKafkaJsonSchemaSerializer<T>
extends AbstractKafkaSchemaSerDe {
    protected boolean autoRegisterSchema;
    protected boolean useLatestVersion;
    protected boolean latestCompatStrict;
    protected ObjectMapper objectMapper = Jackson.newObjectMapper();
    protected SpecificationVersion specVersion;
    protected boolean oneofForNullables;
    protected boolean validate;

    protected void configure(KafkaJsonSchemaSerializerConfig config) {
        this.configureClientProperties(config, (SchemaProvider)new JsonSchemaProvider());
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.useLatestVersion = config.useLatestVersion();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        boolean prettyPrint = config.getBoolean("json.indent.output");
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
        boolean writeDatesAsIso8601 = config.getBoolean("json.write.dates.iso8601");
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, !writeDatesAsIso8601);
        this.specVersion = SpecificationVersion.get((String)config.getString("json.schema.spec.version"));
        this.oneofForNullables = config.getBoolean("json.oneof.for.nullables");
        this.validate = config.getBoolean("json.fail.invalid.schema");
    }

    protected KafkaJsonSchemaSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaJsonSchemaSerializerConfig(props);
        }
        catch (io.confluent.common.config.ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected byte[] serializeImpl(String subject, T object, JsonSchema schema) throws SerializationException, InvalidConfigurationException {
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            if (this.autoRegisterSchema) {
                restClientErrorMsg = "Error registering JSON schema: ";
                id = this.schemaRegistry.register(subject, (ParsedSchema)schema);
            } else if (this.useLatestVersion) {
                restClientErrorMsg = "Error retrieving latest version: ";
                schema = (JsonSchema)this.lookupLatestVersion(subject, (ParsedSchema)schema, this.latestCompatStrict);
                id = this.schemaRegistry.getId(subject, (ParsedSchema)schema);
            } else {
                restClientErrorMsg = "Error retrieving JSON schema: ";
                id = this.schemaRegistry.getId(subject, (ParsedSchema)schema);
            }
            if (this.validate) {
                try {
                    schema.validate(object);
                }
                catch (JsonProcessingException | ValidationException e) {
                    throw new SerializationException("JSON " + object + " does not match schema " + schema.canonicalString(), e);
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            out.write(this.objectMapper.writeValueAsBytes(object));
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing JSON message", (Throwable)e);
        }
        catch (RestClientException e) {
            throw AbstractKafkaJsonSchemaSerializer.toKafkaException((RestClientException)e, (String)(restClientErrorMsg + schema));
        }
    }
}

