/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.json.JsonSchemaAndValue;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializerConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.everit.json.schema.ValidationException;

public abstract class AbstractKafkaJsonSchemaDeserializer<T>
extends AbstractKafkaSchemaSerDe {
    protected ObjectMapper objectMapper = Jackson.newObjectMapper();
    protected Class<T> type;
    protected String typeProperty;
    protected boolean validate;

    protected void configure(KafkaJsonSchemaDeserializerConfig config, Class<T> type) {
        this.configureClientProperties(config, (SchemaProvider)new JsonSchemaProvider());
        this.type = type;
        boolean failUnknownProperties = config.getBoolean("json.fail.unknown.properties");
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failUnknownProperties);
        this.validate = config.getBoolean("json.fail.invalid.schema");
        this.typeProperty = config.getString("type.property");
    }

    protected KafkaJsonSchemaDeserializerConfig deserializerConfig(Map<String, ?> props) {
        try {
            return new KafkaJsonSchemaDeserializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected KafkaJsonSchemaDeserializerConfig deserializerConfig(VerifiableProperties props) {
        return new KafkaJsonSchemaDeserializerConfig(props.props());
    }

    protected T deserialize(byte[] payload) throws SerializationException {
        return (T)this.deserialize(false, null, null, payload);
    }

    protected Object deserialize(boolean includeSchemaAndVersion, String topic, Boolean isKey, byte[] payload) throws SerializationException {
        if (payload == null) {
            return null;
        }
        int id = -1;
        try {
            ByteBuffer buffer = this.getByteBuffer(payload);
            id = buffer.getInt();
            JsonSchema schema = (JsonSchema)this.schemaRegistry.getSchemaById(id);
            String subject = null;
            if (includeSchemaAndVersion) {
                subject = this.subjectName(topic, isKey, schema);
                schema = this.schemaForDeserialize(id, schema, subject, isKey);
            }
            int length = buffer.limit() - 1 - 4;
            int start = buffer.position() + buffer.arrayOffset();
            String typeName = schema.getString(this.typeProperty);
            Object value = this.type != null && !Object.class.equals(this.type) ? this.objectMapper.readValue(buffer.array(), start, length, this.type) : (typeName != null ? this.deriveType(buffer, length, start, typeName) : (Object.class.equals(this.type) ? this.objectMapper.readValue(buffer.array(), start, length, this.type) : this.objectMapper.readTree((InputStream)new ByteArrayInputStream(buffer.array(), start, length))));
            if (this.validate) {
                try {
                    schema.validate(value);
                }
                catch (JsonProcessingException | ValidationException e) {
                    throw new SerializationException("JSON " + value + " does not match schema " + schema.canonicalString(), e);
                }
            }
            if (includeSchemaAndVersion) {
                Integer version = this.schemaVersion(topic, isKey, id, subject, schema, value);
                return new JsonSchemaAndValue(schema.copy(version), value);
            }
            return value;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error deserializing JSON message for id " + id, (Throwable)e);
        }
        catch (RestClientException e) {
            throw new SerializationException("Error retrieving JSON schema for id " + id, (Throwable)e);
        }
    }

    private Object deriveType(ByteBuffer buffer, int length, int start, String typeName) throws IOException {
        try {
            Class<?> cls = Class.forName(typeName);
            return this.objectMapper.readValue(buffer.array(), start, length, cls);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Class " + typeName + " could not be found.");
        }
    }

    private Integer schemaVersion(String topic, Boolean isKey, int id, String subject, JsonSchema schema, Object value) throws IOException, RestClientException {
        Integer version;
        if (this.isDeprecatedSubjectNameStrategy(isKey)) {
            subject = this.getSubjectName(topic, isKey, value, (ParsedSchema)schema);
            JsonSchema subjectSchema = (JsonSchema)this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
            version = this.schemaRegistry.getVersion(subject, (ParsedSchema)subjectSchema);
        } else {
            version = this.schemaRegistry.getVersion(subject, (ParsedSchema)schema);
        }
        return version;
    }

    private String subjectName(String topic, Boolean isKey, JsonSchema schemaFromRegistry) {
        return this.isDeprecatedSubjectNameStrategy(isKey) ? null : this.getSubjectName(topic, isKey, null, (ParsedSchema)schemaFromRegistry);
    }

    private JsonSchema schemaForDeserialize(int id, JsonSchema schemaFromRegistry, String subject, Boolean isKey) throws IOException, RestClientException {
        return this.isDeprecatedSubjectNameStrategy(isKey) ? JsonSchemaUtils.copyOf((JsonSchema)schemaFromRegistry) : (JsonSchema)this.schemaRegistry.getSchemaBySubjectAndId(subject, id);
    }

    protected JsonSchemaAndValue deserializeWithSchemaAndVersion(String topic, boolean isKey, byte[] payload) throws SerializationException {
        return (JsonSchemaAndValue)this.deserialize(true, topic, isKey, payload);
    }
}

