/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.json.SpecificationVersion;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.schemaregistry.rules.RulePhase;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerConfig;
import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdSerializer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.everit.json.schema.ValidationException;

public abstract class AbstractKafkaJsonSchemaSerializer<T>
extends AbstractKafkaSchemaSerDe {
    protected boolean normalizeSchema;
    protected boolean autoRegisterSchema;
    protected boolean propagateSchemaTags;
    protected int useSchemaId = -1;
    protected boolean idCompatStrict;
    protected boolean latestCompatStrict;
    protected ObjectMapper objectMapper = Jackson.newObjectMapper();
    protected SpecificationVersion specVersion;
    protected List<String> scanPackages;
    protected boolean oneofForNullables;
    protected boolean failUnknownProperties;
    protected boolean validate;

    protected void configure(KafkaJsonSchemaSerializerConfig config) {
        this.configureClientProperties(config, (SchemaProvider)new JsonSchemaProvider());
        this.normalizeSchema = config.normalizeSchema();
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.propagateSchemaTags = config.propagateSchemaTags();
        this.useSchemaId = config.useSchemaId();
        this.idCompatStrict = config.getIdCompatibilityStrict();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        boolean prettyPrint = config.getBoolean("json.indent.output");
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
        boolean writeDatesAsIso8601 = config.getBoolean("json.write.dates.iso8601");
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, !writeDatesAsIso8601);
        this.specVersion = SpecificationVersion.get((String)config.getString("json.schema.spec.version"));
        this.scanPackages = config.getList("json.schema.scan.packages");
        this.oneofForNullables = config.getBoolean("json.oneof.for.nullables");
        String inclusion = config.getString("json.default.property.inclusion");
        if (inclusion != null) {
            this.objectMapper.setDefaultPropertyInclusion(JsonInclude.Include.valueOf((String)inclusion));
        }
        this.failUnknownProperties = config.getBoolean("json.fail.unknown.properties");
        this.validate = config.getBoolean("json.fail.invalid.schema");
    }

    protected KafkaJsonSchemaSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaJsonSchemaSerializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    protected byte[] serializeImpl(String subject, T object, JsonSchema schema) throws SerializationException, InvalidConfigurationException {
        return this.serializeImpl(subject, null, null, object, schema);
    }

    protected byte[] serializeImpl(String subject, String topic, Headers headers, T object, JsonSchema schema) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the serializer or use serializer constructor with SchemaRegistryClient.");
        }
        if (object == null) {
            return null;
        }
        Object restClientErrorMsg = "";
        try {
            byte[] byArray;
            block25: {
                AbstractKafkaSchemaSerDe.ExtendedSchema extendedSchema;
                SchemaId schemaId;
                if (this.autoRegisterSchema) {
                    Optional optSchema;
                    restClientErrorMsg = "Error registering JSON schema: ";
                    Schema s = this.registerWithResponse(subject, (ParsedSchema)schema, this.normalizeSchema, this.propagateSchemaTags);
                    if (s.getSchema() != null && (optSchema = this.schemaRegistry.parseSchema(s)).isPresent()) {
                        schema = (JsonSchema)optSchema.get();
                        schema = schema.copy(s.getVersion());
                    }
                    schemaId = new SchemaId("JSON", s.getId(), s.getGuid());
                } else if (this.useSchemaId >= 0) {
                    restClientErrorMsg = "Error retrieving schema ID";
                    schema = (JsonSchema)this.lookupSchemaBySubjectAndId(subject, this.useSchemaId, (ParsedSchema)schema, this.idCompatStrict);
                    Schema schemaEntity = new Schema(subject, null, Integer.valueOf(this.useSchemaId), (ParsedSchema)schema);
                    schemaId = new SchemaId("JSON", Integer.valueOf(this.useSchemaId), schemaEntity.getGuid());
                } else if (this.metadata != null) {
                    restClientErrorMsg = "Error retrieving latest with metadata '" + String.valueOf(this.metadata) + "'";
                    extendedSchema = this.getLatestWithMetadata(subject);
                    schema = (JsonSchema)extendedSchema.getSchema();
                    schemaId = new SchemaId("JSON", extendedSchema.getId(), extendedSchema.getGuid());
                } else if (this.useLatestVersion) {
                    restClientErrorMsg = "Error retrieving latest version: ";
                    extendedSchema = this.lookupLatestVersion(subject, (ParsedSchema)schema, this.latestCompatStrict);
                    schema = (JsonSchema)extendedSchema.getSchema();
                    schemaId = new SchemaId("JSON", extendedSchema.getId(), extendedSchema.getGuid());
                } else {
                    restClientErrorMsg = "Error retrieving JSON schema: ";
                    RegisterSchemaResponse response = this.schemaRegistry.getIdWithResponse(subject, (ParsedSchema)schema, this.normalizeSchema);
                    schemaId = new SchemaId("JSON", Integer.valueOf(response.getId()), response.getGuid());
                }
                object = this.executeRules(subject, topic, headers, RuleMode.WRITE, null, (ParsedSchema)schema, object);
                if (this.validate) {
                    object = this.validateJson(object, schema);
                }
                SchemaIdSerializer schemaIdSerializer = this.schemaIdSerializer(this.isKey);
                try {
                    byte[] payload = this.objectMapper.writeValueAsBytes(object);
                    payload = (byte[])this.executeRules(subject, topic, headers, payload, RulePhase.ENCODING, RuleMode.WRITE, null, (ParsedSchema)schema, payload);
                    byArray = schemaIdSerializer.serialize(topic, this.isKey, headers, payload, schemaId);
                    if (schemaIdSerializer == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (schemaIdSerializer != null) {
                            try {
                                schemaIdSerializer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedIOException e) {
                        throw new TimeoutException("Error serializing JSON message", (Throwable)e);
                    }
                    catch (IOException | RuntimeException e) {
                        throw new SerializationException("Error serializing JSON message", (Throwable)e);
                    }
                    catch (RestClientException e) {
                        throw AbstractKafkaJsonSchemaSerializer.toKafkaException((RestClientException)e, (String)((String)restClientErrorMsg + String.valueOf(schema)));
                    }
                }
                schemaIdSerializer.close();
            }
            return byArray;
        }
        finally {
            this.postOp(object);
        }
    }

    protected T validateJson(T object, JsonSchema schema) throws SerializationException {
        try {
            JsonNode jsonNode = object instanceof JsonNode ? (JsonNode)object : (JsonNode)this.objectMapper.convertValue(object, JsonNode.class);
            jsonNode = schema.validate(jsonNode);
            return (T)(object instanceof JsonNode ? object : this.objectMapper.convertValue((Object)jsonNode, object.getClass()));
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("JSON does not match schema of type " + schema.schemaType(), (Throwable)e);
        }
        catch (ValidationException e) {
            throw new SerializationException("Validation error in JSON, Error report:\n" + e.toJSON().toString(2), (Throwable)e);
        }
    }
}

