/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class ProtobufSchemaUtils {
    private static final ObjectMapper jsonMapper = JacksonMapper.INSTANCE;

    public static ProtobufSchema copyOf(ProtobufSchema schema) {
        return schema.copy();
    }

    public static ProtobufSchema getSchema(Message message) {
        return message != null ? new ProtobufSchema(message.getDescriptorForType()) : null;
    }

    public static Object toObject(JsonNode value, ProtobufSchema schema) throws IOException {
        StringWriter out = new StringWriter();
        jsonMapper.writeValue((Writer)out, (Object)value);
        return ProtobufSchemaUtils.toObject(out.toString(), schema);
    }

    public static Object toObject(String value, ProtobufSchema schema) throws InvalidProtocolBufferException {
        DynamicMessage.Builder message = schema.newMessageBuilder();
        JsonFormat.parser().merge(value, (Message.Builder)message);
        return message.build();
    }

    public static byte[] toJson(Message message) throws IOException {
        if (message == null) {
            return null;
        }
        String jsonString = JsonFormat.printer().includingDefaultValueFields().omittingInsignificantWhitespace().print((MessageOrBuilder)message);
        return jsonString.getBytes(StandardCharsets.UTF_8);
    }
}

