/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.TimestampProto;
import com.google.protobuf.WrappersProto;
import com.google.type.DateProto;
import com.google.type.TimeOfDayProto;
import com.squareup.wire.Syntax;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.SchemaDiff;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.EnumDefinition;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.MessageDefinition;
import io.confluent.protobuf.MetaProto;
import io.confluent.protobuf.type.DecimalProto;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.ranges.IntRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(ProtobufSchema.class);
    public static final String TYPE = "PROTOBUF";
    public static final String SERIALIZED_FORMAT = "serialized";
    public static final String PROTO2 = "proto2";
    public static final String PROTO3 = "proto3";
    public static final String DOC_FIELD = "doc";
    public static final String PARAMS_FIELD = "params";
    public static final String DEFAULT_NAME = "default";
    public static final String MAP_ENTRY_SUFFIX = "Entry";
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    public static final Location DEFAULT_LOCATION = Location.get((String)"");
    public static final String META_LOCATION = "confluent/meta.proto";
    public static final String DECIMAL_LOCATION = "confluent/type/decimal.proto";
    public static final String DATE_LOCATION = "google/type/date.proto";
    public static final String TIME_LOCATION = "google/type/timeofday.proto";
    public static final String TIMESTAMP_LOCATION = "google/protobuf/timestamp.proto";
    public static final String WRAPPER_LOCATION = "google/protobuf/wrappers.proto";
    private static final ProtoFileElement META_SCHEMA = ProtobufSchema.toProtoFile(MetaProto.getDescriptor().toProto());
    private static final ProtoFileElement DECIMAL_SCHEMA = ProtobufSchema.toProtoFile(DecimalProto.getDescriptor().toProto());
    private static final ProtoFileElement DATE_SCHEMA = ProtobufSchema.toProtoFile(DateProto.getDescriptor().toProto());
    private static final ProtoFileElement TIME_SCHEMA = ProtobufSchema.toProtoFile(TimeOfDayProto.getDescriptor().toProto());
    private static final ProtoFileElement TIMESTAMP_SCHEMA = ProtobufSchema.toProtoFile(TimestampProto.getDescriptor().toProto());
    private static final ProtoFileElement WRAPPER_SCHEMA = ProtobufSchema.toProtoFile(WrappersProto.getDescriptor().toProto());
    private final ProtoFileElement schemaObj;
    private final Integer version;
    private final String name;
    private final List<SchemaReference> references;
    private final Map<String, ProtoFileElement> dependencies;
    private transient String canonicalString;
    private transient DynamicSchema dynamicSchema;
    private transient Descriptors.Descriptor descriptor;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();

    public ProtobufSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null, null);
    }

    public ProtobufSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version, String name) {
        try {
            this.schemaObj = this.toProtoFile(schemaString);
            this.version = version;
            this.name = name;
            this.references = Collections.unmodifiableList(references);
            this.dependencies = Collections.unmodifiableMap(resolvedReferences.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toProtoFile((String)e.getValue()))));
        }
        catch (IllegalStateException e2) {
            log.error("Could not parse Protobuf schema " + schemaString + " with references " + references, (Throwable)e2);
            throw e2;
        }
    }

    public ProtobufSchema(ProtoFileElement protoFileElement, List<SchemaReference> references, Map<String, ProtoFileElement> dependencies) {
        this.schemaObj = protoFileElement;
        this.version = null;
        this.name = null;
        this.references = Collections.unmodifiableList(references);
        this.dependencies = Collections.unmodifiableMap(dependencies);
    }

    public ProtobufSchema(Descriptors.Descriptor descriptor) {
        this(descriptor, Collections.emptyList());
    }

    public ProtobufSchema(Descriptors.Descriptor descriptor, List<SchemaReference> references) {
        HashMap<String, ProtoFileElement> dependencies = new HashMap<String, ProtoFileElement>();
        this.schemaObj = ProtobufSchema.toProtoFile(descriptor.getFile(), dependencies);
        this.version = null;
        this.name = descriptor.getFullName();
        this.references = Collections.unmodifiableList(references);
        this.dependencies = Collections.unmodifiableMap(dependencies);
        this.descriptor = descriptor;
    }

    private ProtobufSchema(ProtoFileElement schemaObj, Integer version, String name, List<SchemaReference> references, Map<String, ProtoFileElement> dependencies, String canonicalString, DynamicSchema dynamicSchema, Descriptors.Descriptor descriptor) {
        this.schemaObj = schemaObj;
        this.version = version;
        this.name = name;
        this.references = references;
        this.dependencies = dependencies;
        this.canonicalString = canonicalString;
        this.dynamicSchema = dynamicSchema;
        this.descriptor = descriptor;
    }

    public ProtobufSchema copy() {
        return new ProtobufSchema(this.schemaObj, this.version, this.name, this.references, this.dependencies, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    public ProtobufSchema copy(Integer version) {
        return new ProtobufSchema(this.schemaObj, version, this.name, this.references, this.dependencies, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    public ProtobufSchema copy(String name) {
        return new ProtobufSchema(this.schemaObj, this.version, name, this.references, this.dependencies, this.canonicalString, this.dynamicSchema, Objects.equals(this.name, name) ? this.descriptor : null);
    }

    public ProtobufSchema copy(List<SchemaReference> references) {
        return new ProtobufSchema(this.schemaObj, this.version, this.name, references, this.dependencies, this.canonicalString, this.dynamicSchema, this.descriptor);
    }

    private ProtoFileElement toProtoFile(String schema) {
        try {
            return ProtoParser.Companion.parse(DEFAULT_LOCATION, schema);
        }
        catch (Exception e) {
            try {
                byte[] bytes = base64Decoder.decode(schema);
                return ProtobufSchema.toProtoFile(DescriptorProtos.FileDescriptorProto.parseFrom((byte[])bytes));
            }
            catch (Exception pe) {
                throw new IllegalArgumentException("Could not parse Protobuf", e);
            }
        }
    }

    private static ProtoFileElement toProtoFile(Descriptors.FileDescriptor file, Map<String, ProtoFileElement> dependencies) {
        for (Descriptors.FileDescriptor dependency : file.getDependencies()) {
            String depName = dependency.getName();
            dependencies.put(depName, ProtobufSchema.toProtoFile(dependency, dependencies));
        }
        return ProtobufSchema.toProtoFile(file.toProto());
    }

    private static ProtoFileElement toProtoFile(DescriptorProtos.FileDescriptorProto file) {
        MetaProto.Meta meta;
        OptionElement option;
        OptionElement.Kind kind;
        String packageName = file.getPackage();
        if ("".equals(packageName)) {
            packageName = null;
        }
        Syntax syntax = null;
        switch (file.getSyntax()) {
            case "proto2": {
                syntax = Syntax.PROTO_2;
                break;
            }
            case "proto3": {
                syntax = Syntax.PROTO_3;
                break;
            }
        }
        ImmutableList.Builder types = ImmutableList.builder();
        for (DescriptorProtos.DescriptorProto md : file.getMessageTypeList()) {
            MessageElement message = ProtobufSchema.toMessage(file, md);
            types.add((Object)message);
        }
        for (DescriptorProtos.EnumDescriptorProto ed : file.getEnumTypeList()) {
            EnumElement enumer = ProtobufSchema.toEnum(ed);
            types.add((Object)enumer);
        }
        ImmutableList.Builder imports = ImmutableList.builder();
        ImmutableList.Builder publicImports = ImmutableList.builder();
        ProtocolStringList dependencyList = file.getDependencyList();
        HashSet publicDependencyList = new HashSet(file.getPublicDependencyList());
        for (int i = 0; i < dependencyList.size(); ++i) {
            String depName = (String)dependencyList.get(i);
            if (publicDependencyList.contains(i)) {
                publicImports.add((Object)depName);
                continue;
            }
            imports.add((Object)depName);
        }
        ImmutableList.Builder options = ImmutableList.builder();
        if (file.getOptions().hasJavaPackage()) {
            kind = OptionElement.Kind.STRING;
            option = new OptionElement("java_package", kind, (Object)file.getOptions().getJavaPackage(), false);
            options.add((Object)option);
        }
        if (file.getOptions().hasJavaOuterClassname()) {
            kind = OptionElement.Kind.STRING;
            option = new OptionElement("java_outer_classname", kind, (Object)file.getOptions().getJavaOuterClassname(), false);
            options.add((Object)option);
        }
        if (file.getOptions().hasJavaMultipleFiles()) {
            kind = OptionElement.Kind.BOOLEAN;
            option = new OptionElement("java_multiple_files", kind, (Object)file.getOptions().getJavaMultipleFiles(), false);
            options.add((Object)option);
        }
        if (file.getOptions().hasExtension(MetaProto.fileMeta) && (option = ProtobufSchema.toOption("confluent.file_meta", meta = (MetaProto.Meta)file.getOptions().getExtension(MetaProto.fileMeta))) != null) {
            options.add((Object)option);
        }
        return new ProtoFileElement(DEFAULT_LOCATION, packageName, syntax, (List)imports.build(), (List)publicImports.build(), (List)types.build(), Collections.emptyList(), Collections.emptyList(), (List)options.build());
    }

    private static MessageElement toMessage(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.DescriptorProto descriptor) {
        MetaProto.Meta meta;
        OptionElement option;
        ReservedElement reservedElem;
        String name = descriptor.getName();
        log.trace("*** msg name: {}", (Object)name);
        ImmutableList.Builder fields = ImmutableList.builder();
        ImmutableList.Builder nested = ImmutableList.builder();
        ImmutableList.Builder reserved = ImmutableList.builder();
        LinkedHashMap<String, ImmutableList.Builder> oneofsMap = new LinkedHashMap<String, ImmutableList.Builder>();
        for (Object od : descriptor.getOneofDeclList()) {
            oneofsMap.put(od.getName(), ImmutableList.builder());
        }
        ArrayList oneofs = new ArrayList(oneofsMap.entrySet());
        for (DescriptorProtos.FieldDescriptorProto fd : descriptor.getFieldList()) {
            FieldElement field;
            if (fd.hasOneofIndex()) {
                field = ProtobufSchema.toField(file, fd, true);
                ((ImmutableList.Builder)((Map.Entry)oneofs.get(fd.getOneofIndex())).getValue()).add((Object)field);
                continue;
            }
            field = ProtobufSchema.toField(file, fd, false);
            fields.add((Object)field);
        }
        for (DescriptorProtos.DescriptorProto nestedDesc : descriptor.getNestedTypeList()) {
            MessageElement nestedMessage = ProtobufSchema.toMessage(file, nestedDesc);
            nested.add((Object)nestedMessage);
        }
        for (DescriptorProtos.DescriptorProto nestedDesc : descriptor.getEnumTypeList()) {
            EnumElement nestedEnum = ProtobufSchema.toEnum((DescriptorProtos.EnumDescriptorProto)nestedDesc);
            nested.add((Object)nestedEnum);
        }
        for (DescriptorProtos.DescriptorProto.ReservedRange range : descriptor.getReservedRangeList()) {
            reservedElem = ProtobufSchema.toReserved(range);
            reserved.add((Object)reservedElem);
        }
        for (String reservedName : descriptor.getReservedNameList()) {
            reservedElem = new ReservedElement(DEFAULT_LOCATION, "", Collections.singletonList(reservedName));
            reserved.add((Object)reservedElem);
        }
        ImmutableList.Builder options = ImmutableList.builder();
        if (descriptor.getOptions().hasMapEntry()) {
            OptionElement.Kind kind = OptionElement.Kind.BOOLEAN;
            option = new OptionElement("map_entry", kind, (Object)descriptor.getOptions().getMapEntry(), false);
            options.add((Object)option);
        }
        if (descriptor.getOptions().hasExtension(MetaProto.messageMeta) && (option = ProtobufSchema.toOption("confluent.message_meta", meta = (MetaProto.Meta)descriptor.getOptions().getExtension(MetaProto.messageMeta))) != null) {
            options.add((Object)option);
        }
        return new MessageElement(DEFAULT_LOCATION, name, "", (List)nested.build(), (List)options.build(), (List)reserved.build(), (List)fields.build(), oneofs.stream().map(e -> ProtobufSchema.toOneof((String)e.getKey(), (ImmutableList.Builder<FieldElement>)((ImmutableList.Builder)e.getValue()))).collect(Collectors.toList()), Collections.emptyList(), Collections.emptyList());
    }

    private static OptionElement toOption(String name, MetaProto.Meta meta) {
        Map params;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String doc = meta.getDoc();
        if (doc != null && !doc.isEmpty()) {
            map.put(DOC_FIELD, doc);
        }
        if ((params = meta.getParamsMap()) != null && !params.isEmpty()) {
            ArrayList keyValues = new ArrayList();
            for (Map.Entry entry : params.entrySet()) {
                HashMap<String, Object> keyValue = new HashMap<String, Object>();
                keyValue.put(KEY_FIELD, entry.getKey());
                keyValue.put(VALUE_FIELD, entry.getValue());
                keyValues.add(keyValue);
            }
            map.put(PARAMS_FIELD, keyValues);
        }
        OptionElement.Kind kind = OptionElement.Kind.MAP;
        return map.isEmpty() ? null : new OptionElement(name, kind, map, true);
    }

    private static ReservedElement toReserved(DescriptorProtos.DescriptorProto.ReservedRange range) {
        int end;
        ArrayList<Integer> values = new ArrayList<Integer>();
        int start = range.getStart();
        values.add(start == (end = range.getEnd()) ? Integer.valueOf(start) : new IntRange(start, end));
        return new ReservedElement(DEFAULT_LOCATION, "", values);
    }

    private static OneOfElement toOneof(String name, ImmutableList.Builder<FieldElement> fields) {
        log.trace("*** oneof name: {}", (Object)name);
        return new OneOfElement(name, "", (List)fields.build(), Collections.emptyList(), Collections.emptyList());
    }

    private static EnumElement toEnum(DescriptorProtos.EnumDescriptorProto ed) {
        MetaProto.Meta meta;
        OptionElement option;
        String name = ed.getName();
        log.trace("*** enum name: {}", (Object)name);
        ImmutableList.Builder constants = ImmutableList.builder();
        for (DescriptorProtos.EnumValueDescriptorProto ev : ed.getValueList()) {
            MetaProto.Meta meta2;
            OptionElement option2;
            ImmutableList.Builder options = ImmutableList.builder();
            if (ev.getOptions().hasExtension(MetaProto.enumValueMeta) && (option2 = ProtobufSchema.toOption("confluent.enum_value_meta", meta2 = (MetaProto.Meta)ev.getOptions().getExtension(MetaProto.enumValueMeta))) != null) {
                options.add((Object)option2);
            }
            constants.add((Object)new EnumConstantElement(DEFAULT_LOCATION, ev.getName(), ev.getNumber(), "", (List)options.build()));
        }
        ImmutableList.Builder options = ImmutableList.builder();
        if (ed.getOptions().hasAllowAlias()) {
            OptionElement.Kind kind = OptionElement.Kind.BOOLEAN;
            option = new OptionElement("allow_alias", kind, (Object)ed.getOptions().getAllowAlias(), false);
            options.add((Object)option);
        }
        if (ed.getOptions().hasExtension(MetaProto.enumMeta) && (option = ProtobufSchema.toOption("confluent.enum_meta", meta = (MetaProto.Meta)ed.getOptions().getExtension(MetaProto.enumMeta))) != null) {
            options.add((Object)option);
        }
        return new EnumElement(DEFAULT_LOCATION, name, "", (List)options.build(), (List)constants.build());
    }

    private static FieldElement toField(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.FieldDescriptorProto fd, boolean inOneof) {
        MetaProto.Meta meta;
        OptionElement option;
        String name = fd.getName();
        log.trace("*** field name: {}", (Object)name);
        ImmutableList.Builder options = ImmutableList.builder();
        if (fd.getOptions().hasPacked()) {
            OptionElement.Kind kind = OptionElement.Kind.BOOLEAN;
            option = new OptionElement("packed", kind, (Object)fd.getOptions().getPacked(), false);
            options.add((Object)option);
        }
        if (fd.getOptions().hasExtension(MetaProto.fieldMeta) && (option = ProtobufSchema.toOption("confluent.field_meta", meta = (MetaProto.Meta)fd.getOptions().getExtension(MetaProto.fieldMeta))) != null) {
            options.add((Object)option);
        }
        String jsonName = fd.hasJsonName() ? fd.getJsonName() : null;
        String defaultValue = !PROTO3.equals(file.getSyntax()) && fd.hasDefaultValue() ? fd.getDefaultValue() : null;
        return new FieldElement(DEFAULT_LOCATION, inOneof ? null : ProtobufSchema.label(file, fd), ProtobufSchema.dataType(fd), name, defaultValue, jsonName, fd.getNumber(), "", (List)options.build());
    }

    private static Field.Label label(DescriptorProtos.FileDescriptorProto file, DescriptorProtos.FieldDescriptorProto fd) {
        boolean isProto3 = file.getSyntax().equals(PROTO3);
        switch (fd.getLabel()) {
            case LABEL_REQUIRED: {
                return isProto3 ? null : Field.Label.REQUIRED;
            }
            case LABEL_OPTIONAL: {
                return isProto3 ? null : Field.Label.OPTIONAL;
            }
            case LABEL_REPEATED: {
                return Field.Label.REPEATED;
            }
        }
        throw new IllegalArgumentException("Unsupported label");
    }

    private static String dataType(DescriptorProtos.FieldDescriptorProto field) {
        if (field.hasTypeName()) {
            return field.getTypeName();
        }
        DescriptorProtos.FieldDescriptorProto.Type type = field.getType();
        return Descriptors.FieldDescriptor.Type.valueOf((DescriptorProtos.FieldDescriptorProto.Type)type).name().toLowerCase();
    }

    public Descriptors.Descriptor toDescriptor() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.descriptor == null) {
            this.descriptor = this.toDescriptor(this.name());
        }
        return this.descriptor;
    }

    public Descriptors.Descriptor toDescriptor(String name) {
        return this.toDynamicSchema().getMessageDescriptor(name);
    }

    public DynamicMessage.Builder newMessageBuilder() {
        return this.newMessageBuilder(this.name());
    }

    public DynamicMessage.Builder newMessageBuilder(String name) {
        return this.toDynamicSchema().newMessageBuilder(name);
    }

    public Descriptors.EnumValueDescriptor getEnumValue(String enumTypeName, int enumNumber) {
        return this.toDynamicSchema().getEnumValue(enumTypeName, enumNumber);
    }

    private MessageElement firstMessage() {
        for (TypeElement typeElement : this.schemaObj.getTypes()) {
            if (!(typeElement instanceof MessageElement)) continue;
            return (MessageElement)typeElement;
        }
        throw new IllegalArgumentException("Protobuf schema definition contains no message type definitions");
    }

    public DynamicSchema toDynamicSchema() {
        return this.toDynamicSchema(DEFAULT_NAME);
    }

    public DynamicSchema toDynamicSchema(String name) {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.dynamicSchema == null) {
            this.dynamicSchema = ProtobufSchema.toDynamicSchema(name, this.schemaObj, this.dependenciesWithLogicalTypes());
        }
        return this.dynamicSchema;
    }

    private static DynamicSchema toDynamicSchema(String name, ProtoFileElement rootElem, Map<String, ProtoFileElement> dependencies) {
        if (log.isTraceEnabled()) {
            log.trace("*** toDynamicSchema: {}", (Object)ProtobufSchemaUtils.toString(rootElem));
        }
        DynamicSchema.Builder schema = DynamicSchema.newBuilder();
        try {
            Boolean javaMultipleFiles;
            String javaOuterClassname;
            ProtoFileElement dep;
            Syntax syntax = rootElem.getSyntax();
            if (syntax != null) {
                schema.setSyntax(syntax.toString());
            }
            if (rootElem.getPackageName() != null) {
                schema.setPackage(rootElem.getPackageName());
            }
            for (TypeElement typeElem : rootElem.getTypes()) {
                if (typeElem instanceof MessageElement) {
                    MessageDefinition message = ProtobufSchema.toDynamicMessage((MessageElement)typeElem);
                    schema.addMessageDefinition(message);
                    continue;
                }
                if (!(typeElem instanceof EnumElement)) continue;
                EnumDefinition enumer = ProtobufSchema.toDynamicEnum((EnumElement)typeElem);
                schema.addEnumDefinition(enumer);
            }
            for (String ref : rootElem.getImports()) {
                dep = dependencies.get(ref);
                if (dep == null) continue;
                schema.addDependency(ref);
                schema.addSchema(ProtobufSchema.toDynamicSchema(ref, dep, dependencies));
            }
            for (String ref : rootElem.getPublicImports()) {
                dep = dependencies.get(ref);
                if (dep == null) continue;
                schema.addPublicDependency(ref);
                schema.addSchema(ProtobufSchema.toDynamicSchema(ref, dep, dependencies));
            }
            String javaPackageName = ProtobufSchema.findOption("java_package", rootElem.getOptions()).map(o -> o.getValue().toString()).orElse(null);
            if (javaPackageName != null) {
                schema.setJavaPackage(javaPackageName);
            }
            if ((javaOuterClassname = (String)ProtobufSchema.findOption("java_outer_classname", rootElem.getOptions()).map(o -> o.getValue().toString()).orElse(null)) != null) {
                schema.setJavaOuterClassname(javaOuterClassname);
            }
            if ((javaMultipleFiles = (Boolean)ProtobufSchema.findOption("java_multiple_files", rootElem.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null)) != null) {
                schema.setJavaMultipleFiles(javaMultipleFiles);
            }
            Optional<OptionElement> meta = ProtobufSchema.findOption("confluent.file_meta", rootElem.getOptions());
            String doc = ProtobufSchema.findDoc(meta);
            Map<String, String> params = ProtobufSchema.findParams(meta);
            schema.setMeta(doc, params);
            schema.setName(name);
            return schema.build();
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static MessageDefinition toDynamicMessage(MessageElement messageElem) {
        String jsonName;
        String defaultVal;
        log.trace("*** message: {}", (Object)messageElem.getName());
        MessageDefinition.Builder message = MessageDefinition.newBuilder(messageElem.getName());
        for (Object type : messageElem.getNestedTypes()) {
            if (type instanceof MessageElement) {
                message.addMessageDefinition(ProtobufSchema.toDynamicMessage((MessageElement)type));
                continue;
            }
            if (!(type instanceof EnumElement)) continue;
            message.addEnumDefinition(ProtobufSchema.toDynamicEnum((EnumElement)type));
        }
        HashSet<String> added = new HashSet<String>();
        for (OneOfElement oneof : messageElem.getOneOfs()) {
            MessageDefinition.OneofBuilder oneofBuilder = message.addOneof(oneof.getName());
            for (FieldElement field : oneof.getFields()) {
                defaultVal = field.getDefaultValue();
                jsonName = ProtobufSchema.findOption("json_name", field.getOptions()).map(o -> o.getValue().toString()).orElse(null);
                Optional<OptionElement> meta = ProtobufSchema.findOption("confluent.field_meta", field.getOptions());
                String doc = ProtobufSchema.findDoc(meta);
                Map<String, String> params = ProtobufSchema.findParams(meta);
                oneofBuilder.addField(field.getType(), field.getName(), field.getTag(), defaultVal, jsonName, doc, params);
                added.add(field.getName());
            }
        }
        for (FieldElement field : messageElem.getFields()) {
            if (added.contains(field.getName())) continue;
            Field.Label fieldLabel = field.getLabel();
            String label = fieldLabel != null ? fieldLabel.toString().toLowerCase() : null;
            String fieldType = field.getType();
            defaultVal = field.getDefaultValue();
            jsonName = field.getJsonName();
            Boolean isPacked = ProtobufSchema.findOption("packed", field.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
            Optional<OptionElement> meta = ProtobufSchema.findOption("confluent.field_meta", field.getOptions());
            String doc = ProtobufSchema.findDoc(meta);
            Map<String, String> params = ProtobufSchema.findParams(meta);
            ProtoType protoType = ProtoType.get((String)fieldType);
            ProtoType keyType = protoType.getKeyType();
            ProtoType valueType = protoType.getValueType();
            if (protoType.isMap() && keyType != null && valueType != null) {
                label = "repeated";
                fieldType = ProtobufSchema.toMapEntry(field.getName());
                MessageDefinition.Builder mapMessage = MessageDefinition.newBuilder(fieldType);
                mapMessage.setMapEntry(true);
                mapMessage.addField(null, keyType.getSimpleName(), KEY_FIELD, 1, null, null, null);
                mapMessage.addField(null, valueType.getSimpleName(), VALUE_FIELD, 2, null, null, null);
                message.addMessageDefinition(mapMessage.build());
            }
            message.addField(label, fieldType, field.getName(), field.getTag(), defaultVal, jsonName, doc, params, isPacked);
        }
        for (ReservedElement reserved : messageElem.getReserveds()) {
            for (Object elem : reserved.getValues()) {
                if (elem instanceof String) {
                    message.addReservedName((String)elem);
                    continue;
                }
                if (elem instanceof Integer) {
                    int tag = (Integer)elem;
                    message.addReservedRange(tag, tag);
                    continue;
                }
                if (elem instanceof IntRange) {
                    IntRange range = (IntRange)elem;
                    message.addReservedRange(range.getStart(), range.getEndInclusive());
                    continue;
                }
                throw new IllegalStateException("Unsupported reserved type: " + elem.getClass().getName());
            }
        }
        Boolean isMapEntry = ProtobufSchema.findOption("map_entry", messageElem.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
        if (isMapEntry != null) {
            message.setMapEntry(isMapEntry);
        }
        Optional<OptionElement> meta = ProtobufSchema.findOption("confluent.message_meta", messageElem.getOptions());
        String doc = ProtobufSchema.findDoc(meta);
        Map<String, String> params = ProtobufSchema.findParams(meta);
        message.setMeta(doc, params);
        return message.build();
    }

    public static Optional<OptionElement> findOption(String name, List<OptionElement> options) {
        return options.stream().filter(o -> o.getName().equals(name)).findFirst();
    }

    public static String findDoc(Optional<OptionElement> meta) {
        return (String)ProtobufSchema.findMeta(meta, DOC_FIELD);
    }

    public static Map<String, String> findParams(Optional<OptionElement> meta) {
        List keyValues = (List)ProtobufSchema.findMeta(meta, PARAMS_FIELD);
        if (keyValues == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map keyValue : keyValues) {
            String key = (String)keyValue.get(KEY_FIELD);
            String value = (String)keyValue.get(VALUE_FIELD);
            params.put(key, value);
        }
        return params;
    }

    public static Object findMeta(Optional<OptionElement> meta, String name) {
        if (!meta.isPresent()) {
            return null;
        }
        OptionElement options = meta.get();
        switch (options.getKind()) {
            case OPTION: {
                OptionElement option = (OptionElement)options.getValue();
                if (option.getName().equals(name)) {
                    return option.getValue();
                }
                return null;
            }
            case MAP: {
                Map map = (Map)options.getValue();
                return map.get(name);
            }
        }
        throw new IllegalStateException("Unexpected custom option kind " + options.getKind());
    }

    private static EnumDefinition toDynamicEnum(EnumElement enumElem) {
        Boolean allowAlias = ProtobufSchema.findOption("allow_alias", enumElem.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(null);
        EnumDefinition.Builder enumer = EnumDefinition.newBuilder(enumElem.getName(), allowAlias);
        for (EnumConstantElement constant : enumElem.getConstants()) {
            Optional<OptionElement> meta = ProtobufSchema.findOption("confluent.enum_value_meta", constant.getOptions());
            String doc = ProtobufSchema.findDoc(meta);
            Map<String, String> params = ProtobufSchema.findParams(meta);
            enumer.addValue(constant.getName(), constant.getTag(), doc, params);
        }
        Optional<OptionElement> meta = ProtobufSchema.findOption("confluent.enum_meta", enumElem.getOptions());
        String doc = ProtobufSchema.findDoc(meta);
        Map<String, String> params = ProtobufSchema.findParams(meta);
        enumer.setMeta(doc, params);
        return enumer.build();
    }

    public ProtoFileElement rawSchema() {
        return this.schemaObj;
    }

    public String schemaType() {
        return TYPE;
    }

    public String name() {
        return this.name != null ? this.name : this.firstMessage().getName();
    }

    public String canonicalString() {
        if (this.schemaObj == null) {
            return null;
        }
        if (this.canonicalString == null) {
            this.canonicalString = ProtobufSchemaUtils.toString(this.schemaObj);
        }
        return this.canonicalString;
    }

    public String formattedString(String format) {
        if (SERIALIZED_FORMAT.equals(format)) {
            DescriptorProtos.FileDescriptorProto file = this.toDynamicSchema().getFileDescriptorProto();
            return base64Encoder.encodeToString(file.toByteArray());
        }
        throw new IllegalArgumentException("Unsupported format " + format);
    }

    public Integer version() {
        return this.version;
    }

    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.dependencies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ProtobufSchemaUtils.toString((ProtoFileElement)e.getValue())));
    }

    public Map<String, ProtoFileElement> dependencies() {
        return this.dependencies;
    }

    public Map<String, ProtoFileElement> dependenciesWithLogicalTypes() {
        HashMap<String, ProtoFileElement> deps = new HashMap<String, ProtoFileElement>(this.dependencies);
        if (!deps.containsKey(META_LOCATION)) {
            deps.put(META_LOCATION, META_SCHEMA);
        }
        if (!deps.containsKey(DECIMAL_LOCATION)) {
            deps.put(DECIMAL_LOCATION, DECIMAL_SCHEMA);
        }
        if (!deps.containsKey(DATE_LOCATION)) {
            deps.put(DATE_LOCATION, DATE_SCHEMA);
        }
        if (!deps.containsKey(TIME_LOCATION)) {
            deps.put(TIME_LOCATION, TIME_SCHEMA);
        }
        if (!deps.containsKey(TIMESTAMP_LOCATION)) {
            deps.put(TIMESTAMP_LOCATION, TIMESTAMP_SCHEMA);
        }
        if (!deps.containsKey(WRAPPER_LOCATION)) {
            deps.put(WRAPPER_LOCATION, WRAPPER_SCHEMA);
        }
        return deps;
    }

    public void validate() {
        this.toDynamicSchema();
    }

    public List<String> isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return Collections.singletonList("Incompatible because of different schema type");
        }
        List<Difference> differences = SchemaDiff.compare((ProtobufSchema)previousSchema, this);
        List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains((Object)diff.getType())).collect(Collectors.toList());
        boolean isCompatible = incompatibleDiffs.isEmpty();
        if (!isCompatible) {
            boolean first = true;
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (Difference incompatibleDiff : incompatibleDiffs) {
                if (first) {
                    log.warn("Found incompatible change: {}", (Object)incompatibleDiff);
                    errorMessages.add(String.format("Found incompatible change: %s", incompatibleDiff));
                    first = false;
                    continue;
                }
                log.debug("Found incompatible change: {}", (Object)incompatibleDiff);
                errorMessages.add(String.format("Found incompatible change: %s", incompatibleDiff));
            }
            return errorMessages;
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtobufSchema that = (ProtobufSchema)o;
        return Objects.equals(this.canonicalString(), that.canonicalString()) && Objects.equals(this.references, that.references) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.canonicalString(), this.references, this.version);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.canonicalString();
    }

    public String fullName() {
        Descriptors.Descriptor descriptor = this.toDescriptor();
        Descriptors.FileDescriptor fd = descriptor.getFile();
        DescriptorProtos.FileOptions o = fd.getOptions();
        String p = o.hasJavaPackage() ? o.getJavaPackage() : fd.getPackage();
        String outer = "";
        if (!o.getJavaMultipleFiles()) {
            if (o.hasJavaOuterClassname()) {
                outer = o.getJavaOuterClassname();
            } else {
                return null;
            }
        }
        StringBuilder inner = new StringBuilder();
        while (descriptor != null) {
            if (inner.length() == 0) {
                inner.insert(0, descriptor.getName());
            } else {
                inner.insert(0, descriptor.getName() + "$");
            }
            descriptor = descriptor.getContainingType();
        }
        String d1 = !outer.isEmpty() || inner.length() != 0 ? "." : "";
        String d2 = !outer.isEmpty() && inner.length() != 0 ? "$" : "";
        return p + d1 + outer + d2 + inner;
    }

    public MessageIndexes toMessageIndexes(String name) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        String[] parts = name.split("\\.");
        List types = this.schemaObj.getTypes();
        block0: for (String part : parts) {
            int i = 0;
            for (TypeElement type : types) {
                if (!(type instanceof MessageElement)) continue;
                if (type.getName().equals(part)) {
                    indexes.add(i);
                    types = type.getNestedTypes();
                    continue block0;
                }
                ++i;
            }
        }
        return new MessageIndexes(indexes);
    }

    public String toMessageName(MessageIndexes indexes) {
        StringBuilder sb = new StringBuilder();
        List types = this.schemaObj.getTypes();
        boolean first = true;
        for (Integer index : indexes.indexes()) {
            if (!first) {
                sb.append(".");
            } else {
                first = false;
            }
            MessageElement message = this.getMessageAtIndex(types, index);
            if (message == null) {
                throw new IllegalArgumentException("Invalid message indexes: " + indexes);
            }
            sb.append(message.getName());
            types = message.getNestedTypes();
        }
        String messageName = sb.toString();
        String packageName = this.schemaObj.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + '.' + messageName : messageName;
    }

    private MessageElement getMessageAtIndex(List<TypeElement> types, int index) {
        int i = 0;
        for (TypeElement type : types) {
            if (!(type instanceof MessageElement)) continue;
            if (index == i) {
                return (MessageElement)type;
            }
            ++i;
        }
        return null;
    }

    public static String toMapEntry(String s) {
        if (s.contains("_")) {
            s = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s);
        }
        return s + MAP_ENTRY_SUFFIX;
    }

    public static String toMapField(String s) {
        if (s.endsWith(MAP_ENTRY_SUFFIX)) {
            s = s.substring(0, s.length() - MAP_ENTRY_SUFFIX.length());
            s = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, s);
        }
        return s;
    }
}

