/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.google.common.base.Objects;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.EnumSchemaDiff;
import io.confluent.kafka.schemaregistry.protobuf.diff.MessageSchemaDiff;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SchemaDiff {
    public static final Set<Difference.Type> COMPATIBLE_CHANGES;

    public static List<Difference> compare(ProtobufSchema original, ProtobufSchema update) {
        Map<String, SchemaReference> originalReferences = original.references().stream().collect(Collectors.toMap(SchemaReference::getName, r -> r, (existing, replacement) -> replacement));
        Map<String, SchemaReference> updateReferences = update.references().stream().collect(Collectors.toMap(SchemaReference::getName, r -> r, (existing, replacement) -> replacement));
        Map<String, ProtoFileElement> originalDependencies = original.dependenciesWithLogicalTypes();
        Map<String, ProtoFileElement> updateDependencies = update.dependenciesWithLogicalTypes();
        Context ctx = new Context(COMPATIBLE_CHANGES);
        SchemaDiff.collectContextInfoForRefs(ctx, originalReferences, originalDependencies, true);
        SchemaDiff.collectContextInfoForRefs(ctx, updateReferences, updateDependencies, false);
        SchemaDiff.compare(ctx, original.rawSchema(), update.rawSchema());
        return ctx.getDifferences();
    }

    static void compare(Context ctx, ProtoFileElement original, ProtoFileElement update) {
        String updatePackageName;
        String originalPackageName = original.getPackageName();
        if (originalPackageName == null) {
            originalPackageName = "";
        }
        if ((updatePackageName = update.getPackageName()) == null) {
            updatePackageName = "";
        }
        ctx.setPackageName(originalPackageName, true);
        ctx.setPackageName(updatePackageName, false);
        if (!Objects.equal((Object)originalPackageName, (Object)updatePackageName)) {
            ctx.addDifference(Difference.Type.PACKAGE_CHANGED);
        }
        SchemaReference dummyRef = new SchemaReference("", "", Integer.valueOf(-1));
        SchemaDiff.collectContextInfo(ctx, originalPackageName, originalPackageName, dummyRef, original.getTypes(), true);
        SchemaDiff.collectContextInfo(ctx, updatePackageName, updatePackageName, dummyRef, update.getTypes(), false);
        SchemaDiff.compareTypeElements(ctx, original.getTypes(), update.getTypes());
    }

    private static void collectContextInfoForRefs(Context ctx, Map<String, SchemaReference> references, Map<String, ProtoFileElement> dependencies, boolean isOriginal) {
        for (Map.Entry<String, ProtoFileElement> entry : dependencies.entrySet()) {
            String refName = entry.getKey();
            ProtoFileElement protoFile = entry.getValue();
            SchemaReference ref = references.get(refName);
            String packageName = protoFile.getPackageName();
            if (packageName == null) {
                packageName = "";
            }
            SchemaDiff.collectContextInfo(ctx, packageName, packageName, ref, protoFile.getTypes(), isOriginal);
        }
    }

    private static void collectContextInfo(Context ctx, String scope, String packageName, SchemaReference ref, List<TypeElement> types, boolean isOriginal) {
        String prefix = scope.isEmpty() ? scope : scope + ".";
        for (TypeElement typeElement : types) {
            String qualifiedName = prefix + typeElement.getName();
            boolean isMap = false;
            Optional<Object> key = Optional.empty();
            Optional<Object> value = Optional.empty();
            if (typeElement instanceof MessageElement) {
                MessageElement messageElement = (MessageElement)typeElement;
                isMap = ProtobufSchema.findOption("map_entry", messageElement.getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(false);
                key = SchemaDiff.findField("key", messageElement.getFields());
                value = SchemaDiff.findField("value", messageElement.getFields());
            }
            ctx.addType(qualifiedName, packageName, ref, typeElement, isMap, key.orElse(null), value.orElse(null), isOriginal);
            SchemaDiff.collectContextInfo(ctx, qualifiedName, packageName, ref, typeElement.getNestedTypes(), isOriginal);
        }
    }

    public static Optional<FieldElement> findField(String name, List<FieldElement> options) {
        return options.stream().filter(o -> o.getName().equals(name)).findFirst();
    }

    public static void compareTypeElements(Context ctx, List<TypeElement> original, List<TypeElement> update) {
        Throwable throwable;
        Context.NamedScope pathScope;
        HashMap<String, MessageElement> originalMessages = new HashMap<String, MessageElement>();
        HashMap<String, MessageElement> updateMessages = new HashMap<String, MessageElement>();
        HashMap<String, Integer> originalMessageIndexes = new HashMap<String, Integer>();
        HashMap<String, Integer> updateMessageIndexes = new HashMap<String, Integer>();
        HashMap<String, EnumElement> originalEnums = new HashMap<String, EnumElement>();
        HashMap<String, EnumElement> updateEnums = new HashMap<String, EnumElement>();
        SchemaDiff.compareMessageElements(original, originalMessages, originalMessageIndexes, originalEnums);
        SchemaDiff.compareMessageElements(update, updateMessages, updateMessageIndexes, updateEnums);
        HashSet allMessageNames = new HashSet(originalMessages.keySet());
        allMessageNames.addAll(updateMessages.keySet());
        HashSet allEnumNames = new HashSet(originalEnums.keySet());
        allEnumNames.addAll(updateEnums.keySet());
        for (String name : allMessageNames) {
            pathScope = ctx.enterName(name);
            throwable = null;
            try {
                MessageElement originalMessage = (MessageElement)originalMessages.get(name);
                MessageElement updateMessage = (MessageElement)updateMessages.get(name);
                if (updateMessage == null) {
                    Context.TypeElementInfo originalType = ctx.getType(name, true);
                    if (originalType == null || originalType.isMap()) continue;
                    ctx.addDifference(Difference.Type.MESSAGE_REMOVED);
                    continue;
                }
                if (originalMessage == null) {
                    Context.TypeElementInfo updateType = ctx.getType(name, false);
                    if (updateType == null || updateType.isMap()) continue;
                    ctx.addDifference(Difference.Type.MESSAGE_ADDED);
                    continue;
                }
                Integer originalMessageIndex = (Integer)originalMessageIndexes.get(name);
                Integer updateMessageIndex = (Integer)updateMessageIndexes.get(name);
                if (originalMessageIndex != null && originalMessageIndex.equals(updateMessageIndex)) {
                    MessageSchemaDiff.compare(ctx, originalMessage, updateMessage);
                    continue;
                }
                ctx.addDifference(Difference.Type.MESSAGE_MOVED);
            }
            catch (Throwable originalMessage) {
                throwable = originalMessage;
                throw originalMessage;
            }
            finally {
                if (pathScope == null) continue;
                if (throwable != null) {
                    try {
                        ((Context.PathScope)pathScope).close();
                    }
                    catch (Throwable originalMessage) {
                        throwable.addSuppressed(originalMessage);
                    }
                    continue;
                }
                ((Context.PathScope)pathScope).close();
            }
        }
        for (String name : allEnumNames) {
            pathScope = ctx.enterName(name);
            throwable = null;
            try {
                EnumElement originalEnum = (EnumElement)originalEnums.get(name);
                EnumElement updateEnum = (EnumElement)updateEnums.get(name);
                if (updateEnum == null) {
                    ctx.addDifference(Difference.Type.ENUM_REMOVED);
                    continue;
                }
                if (originalEnum == null) {
                    ctx.addDifference(Difference.Type.ENUM_ADDED);
                    continue;
                }
                EnumSchemaDiff.compare(ctx, originalEnum, updateEnum);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pathScope == null) continue;
                if (throwable != null) {
                    try {
                        ((Context.PathScope)pathScope).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Context.PathScope)pathScope).close();
            }
        }
    }

    private static void compareMessageElements(List<TypeElement> types, Map<String, MessageElement> messages, Map<String, Integer> messageIndexes, Map<String, EnumElement> enums) {
        int index = 0;
        for (TypeElement typeElement : types) {
            if (typeElement instanceof MessageElement) {
                MessageElement messageElement = (MessageElement)typeElement;
                messages.put(messageElement.getName(), messageElement);
                messageIndexes.put(messageElement.getName(), index++);
                continue;
            }
            if (!(typeElement instanceof EnumElement)) continue;
            EnumElement enumElement = (EnumElement)typeElement;
            enums.put(enumElement.getName(), enumElement);
        }
    }

    static {
        HashSet<Difference.Type> changes = new HashSet<Difference.Type>();
        changes.add(Difference.Type.PACKAGE_CHANGED);
        changes.add(Difference.Type.MESSAGE_ADDED);
        changes.add(Difference.Type.ENUM_ADDED);
        changes.add(Difference.Type.ENUM_REMOVED);
        changes.add(Difference.Type.ENUM_CONST_ADDED);
        changes.add(Difference.Type.ENUM_CONST_CHANGED);
        changes.add(Difference.Type.ENUM_CONST_REMOVED);
        changes.add(Difference.Type.FIELD_ADDED);
        changes.add(Difference.Type.FIELD_REMOVED);
        changes.add(Difference.Type.FIELD_NAME_CHANGED);
        changes.add(Difference.Type.ONEOF_ADDED);
        changes.add(Difference.Type.ONEOF_REMOVED);
        changes.add(Difference.Type.ONEOF_FIELD_ADDED);
        COMPATIBLE_CHANGES = Collections.unmodifiableSet(changes);
    }
}

