/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.dynamic;

import com.google.protobuf.DescriptorProtos;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.DynamicSchema;
import io.confluent.kafka.schemaregistry.protobuf.dynamic.EnumDefinition;
import io.confluent.protobuf.MetaProto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageDefinition {
    private DescriptorProtos.DescriptorProto mMsgType;
    private static Map<String, DescriptorProtos.FieldDescriptorProto.Type> sTypeMap = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Type>();
    private static Map<String, DescriptorProtos.FieldDescriptorProto.Label> sLabelMap;

    public static Builder newBuilder(String msgTypeName) {
        return new Builder(msgTypeName);
    }

    public String toString() {
        return this.mMsgType.toString();
    }

    DescriptorProtos.DescriptorProto getMessageType() {
        return this.mMsgType;
    }

    private MessageDefinition(DescriptorProtos.DescriptorProto msgType) {
        this.mMsgType = msgType;
    }

    static {
        sTypeMap.put("double", DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE);
        sTypeMap.put("float", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT);
        sTypeMap.put("int32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32);
        sTypeMap.put("int64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64);
        sTypeMap.put("uint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32);
        sTypeMap.put("uint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64);
        sTypeMap.put("sint32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32);
        sTypeMap.put("sint64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64);
        sTypeMap.put("fixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32);
        sTypeMap.put("fixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64);
        sTypeMap.put("sfixed32", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32);
        sTypeMap.put("sfixed64", DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64);
        sTypeMap.put("bool", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL);
        sTypeMap.put("string", DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
        sTypeMap.put("bytes", DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES);
        sLabelMap = new HashMap<String, DescriptorProtos.FieldDescriptorProto.Label>();
        sLabelMap.put("optional", DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
        sLabelMap.put("required", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
        sLabelMap.put("repeated", DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
    }

    public static class OneofBuilder {
        private Builder mMsgBuilder;
        private int mIdx;

        public OneofBuilder addField(String type, String name, int num, String defaultVal, String doc, Map<String, String> params) {
            return this.addField(type, name, num, defaultVal, null, doc, params);
        }

        public OneofBuilder addField(String type, String name, int num, String defaultVal, String jsonName, String doc, Map<String, String> params) {
            this.mMsgBuilder.doAddField(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, type, name, num, defaultVal, jsonName, doc, params, null, this);
            return this;
        }

        public Builder msgDefBuilder() {
            return this.mMsgBuilder;
        }

        public int getIdx() {
            return this.mIdx;
        }

        private OneofBuilder(Builder msgBuilder, int oneofIdx) {
            this.mMsgBuilder = msgBuilder;
            this.mIdx = oneofIdx;
        }
    }

    public static class Builder {
        private DescriptorProtos.DescriptorProto.Builder mMsgTypeBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        private int mOneofIndex = 0;

        public Builder addField(String label, String type, String name, int num, String defaultVal, String doc, Map<String, String> params) {
            return this.addField(label, type, name, num, defaultVal, null, doc, params, null);
        }

        public Builder addField(String label, String type, String name, int num, String defaultVal, String jsonName, String doc, Map<String, String> params, Boolean isPacked) {
            DescriptorProtos.FieldDescriptorProto.Label protoLabel = (DescriptorProtos.FieldDescriptorProto.Label)sLabelMap.get(label);
            this.doAddField(protoLabel, type, name, num, defaultVal, jsonName, doc, params, isPacked, null);
            return this;
        }

        public OneofBuilder addOneof(String oneofName) {
            this.mMsgTypeBuilder.addOneofDecl(DescriptorProtos.OneofDescriptorProto.newBuilder().setName(oneofName).build());
            return new OneofBuilder(this, this.mOneofIndex++);
        }

        public boolean containsMessage(String name) {
            List messages = this.mMsgTypeBuilder.getNestedTypeList();
            for (DescriptorProtos.DescriptorProto message : messages) {
                if (!message.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public Builder addMessageDefinition(MessageDefinition msgDef) {
            this.mMsgTypeBuilder.addNestedType(msgDef.getMessageType());
            return this;
        }

        public boolean containsEnum(String name) {
            List enums = this.mMsgTypeBuilder.getEnumTypeList();
            for (DescriptorProtos.EnumDescriptorProto enumer : enums) {
                if (!enumer.getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        public Builder addEnumDefinition(EnumDefinition enumDef) {
            this.mMsgTypeBuilder.addEnumType(enumDef.getEnumType());
            return this;
        }

        public Builder addReservedName(String reservedName) {
            this.mMsgTypeBuilder.addReservedName(reservedName);
            return this;
        }

        public Builder addReservedRange(int start, int end) {
            DescriptorProtos.DescriptorProto.ReservedRange.Builder rangeBuilder = DescriptorProtos.DescriptorProto.ReservedRange.newBuilder();
            rangeBuilder.setStart(start).setEnd(end);
            this.mMsgTypeBuilder.addReservedRange(rangeBuilder.build());
            return this;
        }

        public Builder setMapEntry(boolean mapEntry) {
            DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
            optionsBuilder.setMapEntry(mapEntry);
            this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            return this;
        }

        public Builder setMeta(String doc, Map<String, String> params) {
            MetaProto.Meta meta = DynamicSchema.toMeta(doc, params);
            if (meta != null) {
                DescriptorProtos.MessageOptions.Builder optionsBuilder = DescriptorProtos.MessageOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.messageMeta, (Object)meta);
                this.mMsgTypeBuilder.mergeOptions(optionsBuilder.build());
            }
            return this;
        }

        public MessageDefinition build() {
            return new MessageDefinition(this.mMsgTypeBuilder.build());
        }

        private Builder(String msgTypeName) {
            this.mMsgTypeBuilder.setName(msgTypeName);
        }

        private void doAddField(DescriptorProtos.FieldDescriptorProto.Label label, String type, String name, int num, String defaultVal, String jsonName, String doc, Map<String, String> params, Boolean isPacked, OneofBuilder oneofBuilder) {
            DescriptorProtos.FieldDescriptorProto.Type primType;
            DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
            if (label != null) {
                fieldBuilder.setLabel(label);
            }
            if ((primType = (DescriptorProtos.FieldDescriptorProto.Type)sTypeMap.get(type)) != null) {
                fieldBuilder.setType(primType);
            } else {
                fieldBuilder.setTypeName(type);
            }
            fieldBuilder.setName(name).setNumber(num);
            if (defaultVal != null) {
                fieldBuilder.setDefaultValue(defaultVal);
            }
            if (oneofBuilder != null) {
                fieldBuilder.setOneofIndex(oneofBuilder.getIdx());
            }
            if (jsonName != null) {
                fieldBuilder.setJsonName(jsonName);
            }
            if (isPacked != null) {
                DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
                optionsBuilder.setPacked(isPacked.booleanValue());
                fieldBuilder.mergeOptions(optionsBuilder.build());
            }
            this.setFieldMeta(fieldBuilder, doc, params);
            this.mMsgTypeBuilder.addField(fieldBuilder.build());
        }

        private void setFieldMeta(DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder, String doc, Map<String, String> params) {
            MetaProto.Meta meta = DynamicSchema.toMeta(doc, params);
            if (meta != null) {
                DescriptorProtos.FieldOptions.Builder optionsBuilder = DescriptorProtos.FieldOptions.newBuilder();
                optionsBuilder.setExtension(MetaProto.fieldMeta, (Object)meta);
                fieldBuilder.mergeOptions(optionsBuilder.build());
            }
        }
    }
}

