/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Context {
    private final Set<Difference.Type> compatibleChanges;
    private final Set<MessageElement> schemas;
    private final Map<String, TypeElementInfo> originalTypes;
    private final Map<String, TypeElementInfo> updateTypes;
    private String originalPackageName;
    private String updatePackageName;
    private final Deque<String> fullPath;
    private final Deque<String> fullName;
    private final List<Difference> diffs;

    public Context() {
        this(Collections.emptySet());
    }

    public Context(Set<Difference.Type> compatibleChanges) {
        this.compatibleChanges = compatibleChanges;
        this.schemas = Collections.newSetFromMap(new IdentityHashMap());
        this.originalTypes = new HashMap<String, TypeElementInfo>();
        this.updateTypes = new HashMap<String, TypeElementInfo>();
        this.fullPath = new ArrayDeque<String>();
        this.fullName = new ArrayDeque<String>();
        this.diffs = new ArrayList<Difference>();
    }

    public Context getSubcontext() {
        Context ctx = new Context(this.compatibleChanges);
        ctx.schemas.addAll(this.schemas);
        ctx.originalTypes.putAll(this.originalTypes);
        ctx.updateTypes.putAll(this.updateTypes);
        ctx.originalPackageName = this.originalPackageName;
        ctx.updatePackageName = this.updatePackageName;
        ctx.fullPath.addAll(this.fullPath);
        ctx.fullName.addAll(this.fullName);
        return ctx;
    }

    public void collectTypeInfo(ProtobufSchema schema, boolean isOriginal) {
        Map<String, SchemaReference> references = schema.references().stream().collect(Collectors.toMap(SchemaReference::getName, r -> r, (existing, replacement) -> replacement));
        Map<String, ProtoFileElement> dependencies = schema.dependenciesWithLogicalTypes();
        for (Map.Entry<String, ProtoFileElement> entry : dependencies.entrySet()) {
            String refName = entry.getKey();
            ProtoFileElement protoFile = entry.getValue();
            SchemaReference ref = references.get(refName);
            this.collectTypeInfo(ref, protoFile, isOriginal);
        }
        SchemaReference dummyRef = new SchemaReference("", "", Integer.valueOf(-1));
        this.collectTypeInfo(dummyRef, schema.rawSchema(), isOriginal);
    }

    private void collectTypeInfo(SchemaReference ref, ProtoFileElement protoFile, boolean isOriginal) {
        this.setPackageName(protoFile.getPackageName(), isOriginal);
        this.collectTypeInfo(ref, protoFile.getTypes(), isOriginal);
    }

    private void collectTypeInfo(SchemaReference ref, List<TypeElement> types, boolean isOriginal) {
        for (TypeElement typeElement : types) {
            NamedScope namedScope = this.enterName(typeElement.getName());
            Throwable throwable = null;
            try {
                MessageElement messageElement;
                boolean isMap = false;
                Optional<Object> key = Optional.empty();
                Optional<Object> value = Optional.empty();
                if (typeElement instanceof MessageElement && (isMap = ProtobufSchema.findOption("map_entry", (messageElement = (MessageElement)typeElement).getOptions()).map(o -> Boolean.valueOf(o.getValue().toString())).orElse(false).booleanValue())) {
                    key = Context.findField("key", messageElement.getFields());
                    value = Context.findField("value", messageElement.getFields());
                }
                this.addType(ref, typeElement, isMap, key.orElse(null), value.orElse(null), isOriginal);
                this.collectTypeInfo(ref, typeElement.getNestedTypes(), isOriginal);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (namedScope == null) continue;
                if (throwable != null) {
                    try {
                        namedScope.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                namedScope.close();
            }
        }
    }

    private void addType(SchemaReference ref, TypeElement type, boolean isMap, FieldElement key, FieldElement value, boolean isOriginal) {
        String packageName;
        String name = String.join((CharSequence)".", this.fullPath);
        String string = packageName = isOriginal ? this.originalPackageName : this.updatePackageName;
        if (!packageName.isEmpty()) {
            name = packageName + "." + name;
        }
        TypeElementInfo typeInfo = new TypeElementInfo(packageName, ref, type, isMap, key, value);
        if (isOriginal) {
            this.originalTypes.put(name, typeInfo);
        } else {
            this.updateTypes.put(name, typeInfo);
        }
    }

    private static Optional<FieldElement> findField(String name, List<FieldElement> options) {
        return options.stream().filter(o -> o.getName().equals(name)).findFirst();
    }

    public TypeElementInfo getType(String name, boolean isOriginal) {
        String fullName = this.resolve(name, isOriginal);
        return fullName != null ? this.getTypeForFullName(fullName, isOriginal) : null;
    }

    public void setPackageName(String packageName, boolean isOriginal) {
        String name = packageName;
        if (name == null) {
            name = "";
        }
        if (isOriginal) {
            this.originalPackageName = name;
        } else {
            this.updatePackageName = name;
        }
    }

    public void setFullName(String name) {
        List<String> parts = Arrays.asList(name.split("\\."));
        this.fullPath.clear();
        this.fullName.clear();
        this.fullPath.addAll(parts);
        this.fullName.addAll(parts);
    }

    public PathScope enterPath(String path) {
        return new PathScope(path);
    }

    public NamedScope enterName(String name) {
        return new NamedScope(name);
    }

    public SchemaScope enterSchema(MessageElement schema) {
        return !this.schemas.contains(schema) ? new SchemaScope(schema) : null;
    }

    public String resolve(String name, boolean isOriginal) {
        if (name.startsWith(".")) {
            String n = name.substring(1);
            TypeElementInfo type = this.getTypeForFullName(n, isOriginal);
            if (type != null) {
                return n;
            }
        } else {
            ArrayDeque<String> prefix = new ArrayDeque<String>(this.fullName);
            if (isOriginal) {
                if (!this.originalPackageName.isEmpty()) {
                    prefix.addFirst(this.originalPackageName);
                }
            } else if (!this.updatePackageName.isEmpty()) {
                prefix.addFirst(this.updatePackageName);
            }
            while (!prefix.isEmpty()) {
                String n = String.join((CharSequence)".", prefix) + "." + name;
                TypeElementInfo type = this.getTypeForFullName(n, isOriginal);
                if (type != null) {
                    return n;
                }
                prefix.removeLast();
            }
            TypeElementInfo type = this.getTypeForFullName(name, isOriginal);
            if (type != null) {
                return name;
            }
        }
        return null;
    }

    public TypeElementInfo getTypeForFullName(String fullName, boolean isOriginal) {
        String name = fullName;
        if (name.startsWith(".")) {
            name = name.substring(1);
        }
        if (isOriginal) {
            return this.originalTypes.get(name);
        }
        return this.updateTypes.get(name);
    }

    public boolean isCompatible() {
        boolean notCompatible = this.getDifferences().stream().map(Difference::getType).anyMatch(t -> !this.compatibleChanges.contains(t));
        return !notCompatible;
    }

    public List<Difference> getDifferences() {
        return this.diffs;
    }

    public void addDifference(Difference.Type type) {
        this.diffs.add(new Difference(type, Context.fullPathString(this.fullPath)));
    }

    public void addDifference(String attribute, Difference.Type type) {
        this.fullPath.addLast(attribute);
        this.addDifference(type);
        this.fullPath.removeLast();
    }

    public void addDifferences(List<Difference> differences) {
        this.diffs.addAll(differences);
    }

    private static String fullPathString(Deque<String> fullPath) {
        return "#/" + String.join((CharSequence)"/", fullPath);
    }

    public static class TypeElementInfo {
        private final String packageName;
        private final SchemaReference ref;
        private final TypeElement type;
        private final boolean isMap;
        private final FieldElement key;
        private final FieldElement value;

        public TypeElementInfo(String packageName, SchemaReference ref, TypeElement type, boolean isMap, FieldElement key, FieldElement value) {
            this.packageName = packageName;
            this.ref = ref;
            this.type = type;
            this.isMap = isMap;
            this.key = key;
            this.value = value;
        }

        public String packageName() {
            return this.packageName;
        }

        public SchemaReference reference() {
            return this.ref;
        }

        public TypeElement type() {
            return this.type;
        }

        public boolean isMap() {
            return this.isMap;
        }

        public FieldElement key() {
            return this.key;
        }

        public FieldElement value() {
            return this.value;
        }

        public ProtoType getMapType() {
            return this.isMap ? ProtoType.get((String)("map<" + this.key.getType() + ", " + this.value.getType() + ">")) : null;
        }
    }

    public class SchemaScope
    implements AutoCloseable {
        private final MessageElement schema;

        public SchemaScope(MessageElement schema) {
            this.schema = schema;
            Context.this.schemas.add(schema);
        }

        @Override
        public void close() {
            Context.this.schemas.remove(this.schema);
        }
    }

    public class NamedScope
    extends PathScope {
        public NamedScope(String name) {
            super(name);
            Context.this.fullName.addLast(name);
        }

        @Override
        public void close() {
            Context.this.fullName.removeLast();
            super.close();
        }
    }

    public class PathScope
    implements AutoCloseable {
        public PathScope(String path) {
            Context.this.fullPath.addLast(path);
        }

        @Override
        public void close() {
            Context.this.fullPath.removeLast();
        }
    }
}

