/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Message;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaProtobufSerializer<T extends Message>
extends AbstractKafkaSchemaSerDe {
    protected boolean autoRegisterSchema;
    protected boolean useLatestVersion;
    protected boolean latestCompatStrict;
    protected ReferenceSubjectNameStrategy referenceSubjectNameStrategy;

    protected void configure(KafkaProtobufSerializerConfig config) {
        this.configureClientProperties(config, (SchemaProvider)new ProtobufSchemaProvider());
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.useLatestVersion = config.useLatestVersion();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        this.referenceSubjectNameStrategy = config.referenceSubjectNameStrategyInstance();
    }

    protected KafkaProtobufSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaProtobufSerializerConfig(props);
        }
        catch (io.confluent.common.config.ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected byte[] serializeImpl(String subject, String topic, boolean isKey, T object, ProtobufSchema schema) throws SerializationException, InvalidConfigurationException {
        if (object == null) {
            return null;
        }
        String restClientErrorMsg = "";
        try {
            int id;
            schema = AbstractKafkaProtobufSerializer.resolveDependencies(this.schemaRegistry, this.autoRegisterSchema, this.useLatestVersion, this.latestCompatStrict, (Cache<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema>)this.latestVersions, this.referenceSubjectNameStrategy, topic, isKey, schema);
            if (this.autoRegisterSchema) {
                restClientErrorMsg = "Error registering Protobuf schema: ";
                id = this.schemaRegistry.register(subject, (ParsedSchema)schema);
            } else if (this.useLatestVersion) {
                restClientErrorMsg = "Error retrieving latest version: ";
                schema = (ProtobufSchema)this.lookupLatestVersion(subject, (ParsedSchema)schema, this.latestCompatStrict);
                id = this.schemaRegistry.getId(subject, (ParsedSchema)schema);
            } else {
                restClientErrorMsg = "Error retrieving Protobuf schema: ";
                id = this.schemaRegistry.getId(subject, (ParsedSchema)schema);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            MessageIndexes indexes = schema.toMessageIndexes(object.getDescriptorForType().getFullName());
            out.write(indexes.toByteArray());
            object.writeTo((OutputStream)out);
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Protobuf message", (Throwable)e);
        }
        catch (RestClientException e) {
            throw AbstractKafkaProtobufSerializer.toKafkaException((RestClientException)e, (String)(restClientErrorMsg + schema));
        }
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Cache<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema> latestVersions, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        if (schema.dependencies().isEmpty() || !schema.references().isEmpty()) {
            return schema;
        }
        Schema s = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, strategy, topic, isKey, null, schema.rawSchema(), schema.dependencies());
        return schema.copy(s.getReferences());
    }

    private static Schema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Cache<AbstractKafkaSchemaSerDe.SubjectSchema, ParsedSchema> latestVersions, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, String name, ProtoFileElement protoFileElement, Map<String, ProtoFileElement> dependencies) throws IOException, RestClientException {
        String subject;
        Schema subschema;
        ArrayList<SchemaReference> references = new ArrayList<SchemaReference>();
        for (String dep : protoFileElement.getImports()) {
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        for (String dep : protoFileElement.getPublicImports()) {
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        ProtobufSchema schema = new ProtobufSchema(protoFileElement, references, dependencies);
        Integer id = null;
        Integer version = null;
        String string = subject = name != null ? strategy.subjectName(name, topic, isKey, (ParsedSchema)schema) : null;
        if (subject != null) {
            if (autoRegisterSchema) {
                id = schemaRegistry.register(subject, (ParsedSchema)schema);
            } else if (useLatestVersion) {
                schema = (ProtobufSchema)AbstractKafkaProtobufSerializer.lookupLatestVersion((SchemaRegistryClient)schemaRegistry, (String)subject, (ParsedSchema)schema, latestVersions, (boolean)latestCompatStrict);
                id = schemaRegistry.getId(subject, (ParsedSchema)schema);
            } else {
                id = schemaRegistry.getId(subject, (ParsedSchema)schema);
            }
            version = schemaRegistry.getVersion(subject, (ParsedSchema)schema);
        }
        return new Schema(subject, version, id, schema.schemaType(), schema.references(), schema.canonicalString());
    }
}

