/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.confluent.kafka.formatter.SchemaMessageReader;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Properties;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class ProtobufMessageReader
extends SchemaMessageReader<Message> {
    public ProtobufMessageReader() {
    }

    ProtobufMessageReader(SchemaRegistryClient schemaRegistryClient, ProtobufSchema keySchema, ProtobufSchema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean autoRegister, boolean useLatest) {
        super(schemaRegistryClient, (ParsedSchema)keySchema, (ParsedSchema)valueSchema, topic, parseKey, reader, autoRegister, useLatest);
    }

    public void init(InputStream inputStream, Properties props) {
        super.init(inputStream, props);
        if (props.containsKey("key.schema.full.name")) {
            String keySchemaFullName = props.getProperty("key.schema.full.name").trim();
            this.keySchema = ((ProtobufSchema)this.keySchema).copy(keySchemaFullName);
        }
        if (props.containsKey("value.schema.full.name")) {
            String valueSchemaFullName = props.getProperty("value.schema.full.name").trim();
            this.valueSchema = ((ProtobufSchema)this.valueSchema).copy(valueSchemaFullName);
        }
    }

    protected SchemaMessageSerializer<Message> createSerializer(SchemaRegistryClient schemaRegistryClient, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
        return new ProtobufMessageSerializer(schemaRegistryClient, autoRegister, useLatest, keySerializer);
    }

    protected SchemaProvider getProvider() {
        return new ProtobufSchemaProvider();
    }

    protected Message readFrom(String jsonString, ParsedSchema schema) {
        try {
            return (Message)ProtobufSchemaUtils.toObject((String)jsonString, (ProtobufSchema)((ProtobufSchema)schema));
        }
        catch (InvalidProtocolBufferException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Protobuf of schema %s", jsonString, schema), (Throwable)e);
        }
    }

    static class ProtobufMessageSerializer
    extends AbstractKafkaProtobufSerializer
    implements SchemaMessageSerializer<Message> {
        protected final Serializer keySerializer;

        ProtobufMessageSerializer(SchemaRegistryClient schemaRegistryClient, boolean autoRegister, boolean useLatest, Serializer keySerializer) {
            this.schemaRegistry = schemaRegistryClient;
            this.autoRegisterSchema = autoRegister;
            this.useLatestVersion = useLatest;
            this.keySerializer = keySerializer;
        }

        public Serializer getKeySerializer() {
            return this.keySerializer;
        }

        public byte[] serializeKey(String topic, Object payload) {
            return this.keySerializer.serialize(topic, payload);
        }

        public byte[] serialize(String subject, String topic, boolean isKey, Message object, ParsedSchema schema) {
            return super.serializeImpl(subject, topic, isKey, object, (ProtobufSchema)schema);
        }
    }
}

