/*
 * Copyright 2020 Confluent Inc.
 *
 * Licensed under the Confluent Community License (the "License"); you may not use
 * this file except in compliance with the License.  You may obtain a copy of the
 * License at
 *
 * http://www.confluent.io/confluent-community-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 *
 */

package io.confluent.kafka.serializers.protobuf;

import java.util.Map;

import org.apache.kafka.common.config.ConfigDef;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;

public class KafkaProtobufDeserializerConfig extends AbstractKafkaSchemaSerDeConfig {

  public static final String SPECIFIC_PROTOBUF_KEY_TYPE = "specific.protobuf.key.type";
  public static final String SPECIFIC_PROTOBUF_KEY_TYPE_DOC =
      "A class generated by Protocol buffers that the message key should be deserialized to";

  public static final String SPECIFIC_PROTOBUF_VALUE_TYPE = "specific.protobuf.value.type";
  public static final String SPECIFIC_PROTOBUF_VALUE_TYPE_DOC =
      "A class generated by Protocol buffers that the message value should be deserialized to";

  public static final String DERIVE_TYPE_CONFIG = "derive.type";
  public static final String DERIVE_TYPE_DOC =
      "Whether to derive the class based on `java_outer_classname` and `java_multiple_files`.";

  private static final ConfigDef config;

  static {
    config = baseConfigDef().define(
        SPECIFIC_PROTOBUF_KEY_TYPE,
        ConfigDef.Type.CLASS,
        Object.class,
        ConfigDef.Importance.MEDIUM,
        SPECIFIC_PROTOBUF_KEY_TYPE_DOC
    ).define(
        SPECIFIC_PROTOBUF_VALUE_TYPE,
        ConfigDef.Type.CLASS,
        Object.class,
        ConfigDef.Importance.MEDIUM,
        SPECIFIC_PROTOBUF_VALUE_TYPE_DOC
    ).define(
        DERIVE_TYPE_CONFIG,
        ConfigDef.Type.BOOLEAN,
        false,
        ConfigDef.Importance.MEDIUM,
        DERIVE_TYPE_DOC
    );
  }

  public KafkaProtobufDeserializerConfig(Map<?, ?> props) {
    super(config, props);
  }
}
