/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.converters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafkarest.converters.ConversionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroConverter {
    private static final Logger log = LoggerFactory.getLogger(AvroConverter.class);
    private static final EncoderFactory encoderFactory = EncoderFactory.get();
    private static final DecoderFactory decoderFactory = DecoderFactory.get();
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final Map<String, Schema> primitiveSchemas;

    public static Object toAvro(JsonNode value, Schema schema) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            jsonMapper.writeValue((OutputStream)out, (Object)value);
            GenericDatumReader reader = new GenericDatumReader(schema);
            Object object = reader.read(null, (Decoder)decoderFactory.jsonDecoder(schema, (InputStream)new ByteArrayInputStream(out.toByteArray())));
            out.close();
            return object;
        }
        catch (IOException | RuntimeException e) {
            throw new ConversionException("Failed to convert JSON to Avro: " + e.getMessage());
        }
    }

    public static JsonNodeAndSize toJson(Object value) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Schema schema = AvroConverter.getSchema(value);
            JsonEncoder encoder = encoderFactory.jsonEncoder(schema, (OutputStream)out);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            Object wrappedValue = value;
            if (value instanceof byte[]) {
                wrappedValue = ByteBuffer.wrap((byte[])value);
            }
            writer.write(wrappedValue, (Encoder)encoder);
            encoder.flush();
            byte[] bytes = out.toByteArray();
            out.close();
            return new JsonNodeAndSize(jsonMapper.readTree(bytes), bytes.length);
        }
        catch (IOException e) {
            log.error("Jackson failed to deserialize JSON generated by Avro's JSON encoder: ", (Throwable)e);
            throw new ConversionException("Failed to convert Avro to JSON: " + e.getMessage());
        }
        catch (RuntimeException e) {
            log.error("Unexpected exception convertion Avro to JSON: ", (Throwable)e);
            throw new ConversionException("Failed to convert Avro to JSON: " + e.getMessage());
        }
    }

    private static Schema getSchema(Object value) {
        if (value instanceof GenericContainer) {
            return ((GenericContainer)value).getSchema();
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            if (mapValue.isEmpty()) {
                return Schema.createMap((Schema)primitiveSchemas.get("Null"));
            }
            Schema valueSchema = AvroConverter.getSchema(mapValue.values().iterator().next());
            return Schema.createMap((Schema)valueSchema);
        }
        if (value == null) {
            return primitiveSchemas.get("Null");
        }
        if (value instanceof Boolean) {
            return primitiveSchemas.get("Boolean");
        }
        if (value instanceof Integer) {
            return primitiveSchemas.get("Integer");
        }
        if (value instanceof Long) {
            return primitiveSchemas.get("Long");
        }
        if (value instanceof Float) {
            return primitiveSchemas.get("Float");
        }
        if (value instanceof Double) {
            return primitiveSchemas.get("Double");
        }
        if (value instanceof String) {
            return primitiveSchemas.get("String");
        }
        if (value instanceof byte[] || value instanceof ByteBuffer) {
            return primitiveSchemas.get("Bytes");
        }
        throw new ConversionException("Couldn't determine Schema from object");
    }

    private static Schema createPrimitiveSchema(Schema.Parser parser, String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return parser.parse(schemaString);
    }

    static {
        Schema.Parser parser = new Schema.Parser();
        primitiveSchemas = new HashMap<String, Schema>();
        primitiveSchemas.put("Null", AvroConverter.createPrimitiveSchema(parser, "null"));
        primitiveSchemas.put("Boolean", AvroConverter.createPrimitiveSchema(parser, "boolean"));
        primitiveSchemas.put("Integer", AvroConverter.createPrimitiveSchema(parser, "int"));
        primitiveSchemas.put("Long", AvroConverter.createPrimitiveSchema(parser, "long"));
        primitiveSchemas.put("Float", AvroConverter.createPrimitiveSchema(parser, "float"));
        primitiveSchemas.put("Double", AvroConverter.createPrimitiveSchema(parser, "double"));
        primitiveSchemas.put("String", AvroConverter.createPrimitiveSchema(parser, "string"));
        primitiveSchemas.put("Bytes", AvroConverter.createPrimitiveSchema(parser, "bytes"));
    }

    public static class JsonNodeAndSize {
        public JsonNode json;
        public long size;

        public JsonNodeAndSize(JsonNode json, long size) {
            this.json = json;
            this.size = size;
        }
    }
}

