/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.ConsumerRecord;
import io.confluent.kafkarest.entities.EntityUtils;
import io.confluent.rest.validation.ConstraintViolations;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class BinaryConsumerRecord
extends ConsumerRecord<byte[], byte[]> {
    @JsonCreator
    public BinaryConsumerRecord(@JsonProperty(value="topic") String topic, @JsonProperty(value="key") String key, @JsonProperty(value="value") String value, @JsonProperty(value="partition") int partition, @JsonProperty(value="offset") long offset) throws IOException {
        super(topic, BinaryConsumerRecord.decodeBinary(key, "key"), BinaryConsumerRecord.decodeBinary(value, "value"), partition, offset);
        try {
            this.value = EntityUtils.parseBase64Binary(value);
        }
        catch (IllegalArgumentException e) {
            throw ConstraintViolations.simpleException((String)"Record value contains invalid base64 encoding");
        }
    }

    public BinaryConsumerRecord(String topic, byte[] key, byte[] value, int partition, long offset) {
        super(topic, key, value, partition, offset);
    }

    @Override
    @JsonProperty(value="key")
    public String getJsonKey() {
        if (this.key == null) {
            return null;
        }
        return EntityUtils.encodeBase64Binary((byte[])this.key);
    }

    @Override
    @JsonProperty(value="value")
    public String getJsonValue() {
        if (this.value == null) {
            return null;
        }
        return EntityUtils.encodeBase64Binary((byte[])this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryConsumerRecord that = (BinaryConsumerRecord)o;
        return this.partition == that.partition && this.offset == that.offset && Objects.equals(this.topic, that.topic) && Arrays.equals((byte[])this.key, (byte[])that.key) && Arrays.equals((byte[])this.value, (byte[])that.value);
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.topic, this.key, this.value, this.partition, this.offset});
    }

    private static byte[] decodeBinary(String binary, String field) {
        try {
            return binary == null ? null : EntityUtils.parseBase64Binary(binary);
        }
        catch (IllegalArgumentException e) {
            throw ConstraintViolations.simpleException((String)("Record " + field + " contains invalid base64 encoding"));
        }
    }
}

