/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public abstract class ConsumerRecord<K, V> {
    protected String topic;
    protected K key;
    @NotNull
    protected V value;
    @Min(value=0L)
    protected @Min(value=0L) int partition;
    @Min(value=0L)
    protected @Min(value=0L) long offset;

    public ConsumerRecord(String topic, K key, V value, int partition, long offset) {
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.offset = offset;
    }

    @JsonProperty
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @JsonIgnore
    public K getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public Object getJsonKey() {
        return this.key;
    }

    @JsonIgnore
    public void setKey(K key) {
        this.key = key;
    }

    @JsonIgnore
    public V getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public Object getJsonValue() {
        return this.value;
    }

    @JsonIgnore
    public void setValue(V value) {
        this.value = value;
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public void setPartition(int partition) {
        this.partition = partition;
    }

    @JsonProperty
    public long getOffset() {
        return this.offset;
    }

    @JsonProperty
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerRecord that = (ConsumerRecord)o;
        return this.partition == that.partition && this.offset == that.offset && Objects.equals(this.topic, that.topic) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.key, this.value, this.partition, this.offset);
    }
}

